/**
 *  @Dharmendra.Prajapati
 *  Research Type Grid
 */
Ext.define('Academia.view.personinfo.common.pasthistory.SeminarDetailsGrid', {
   // extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.seminardetailsgrid',
    title: getPersonModuleTranslation('SEMINAR_DETAILS'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode:true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode:true
    }],
    columns: [{
        header: getPersonModuleTranslation('SEMINAR_TYPE1'),
        dataIndex: 'seminarType',
        sortable: true,
        flex: .2,
        renderer : function(obj){
        	return columnObjRender(obj, "value");
        }
    }, {
        header: getPersonModuleTranslation('SEMINAR_NAME'),
        dataIndex: 'seminarName',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('CONFERENCE_TYPE'),
        dataIndex: 'conferenceType',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('PLACE'),
        dataIndex: 'placeOfSeminar',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getPersonModuleTranslation('To_Date'),
        dataIndex: 'toDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    },{
        header: getPersonModuleTranslation('ORGANIZED_BY'),
        dataIndex: 'organizedBy',
        sortable:true,
        flex: .2
    },{
        header: getPersonModuleTranslation('DOCUMENT'),
        dataIndex: 'noOfdocument',
        sortable:true,
        flex: .2,
        renderer : function(val){
        	if (!isNullOrEmpty(val) && val > 0) {
        		return '<a href="#">'+val+'</a>';
        	}
		}
    }],

   initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.pasthistory.SeminarTypeGridStr');
    }

});