/**
 *  @author Amit G
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerCurrentPaymentTermEditGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feepayercurrentpaymenttermeditgrid',
	border: true,
	title:getPersonModuleTranslation('PAYMENT_TERMS'),
	cls:'centerAlignTitle',
	store : 'personinfo.common.personalinfo.FeePayerCurrentPaymentTermEditGridStore',
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		header : getAdmissionTranslation('FEE_TYPE'),
		dataIndex : 'feePlanType',
		flex : 1	  
	},{
		header : getAdmissionTranslation('FEE_NAME'),
		dataIndex : 'feePlanName',
		flex : 1	  
	},{
		header : getPersonModuleTranslation('PAYMENT_TERM_IN_SELECTION'),
		dataIndex : 'feeRuleNameOnlyForEditAndView',
		flex : 1,
		editor: {
            xtype: 'customcombobox',
            name: 'paymentTermCombo',
            itemId: 'paymentTermCombo',
            valueField: 'feePlanRuleName',
            displayField: 'feePlanRuleName',
            queryMode:'local',
    		listeners: {
    			focus: function(combo) {
                	var grid = combo.up('grid');
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                	var userInfo =  Academia.model.authentication.PortalInfoModel
                	var studentId = userInfo.data.student.id;
                	Ext.Ajax.request({
						type: 'rest',
						url: SERVERURL.PATH_FIND_SPECIFIC_FEEPLAN_RULEBYFEEPLAN,
						params:{
							feePlanId: selectedRecord.data.feePlanId
						},
						method: 'GET',
						async: false,
						success: function(res, action) {
							getJsonList = Ext.decode(res.responseText); 
		                    var store = Ext.create('Academia.store.personinfo.common.personalinfo.FeePayerCurrentTermEditComboStore');
		                    combo.bindStore(store);
		                    //var comboStore =  selectedRecord.data.feePlanRules;
							 if(store.getRange()){
								 store.removeAll();	 
							 }
							 store.add(getJsonList);
						}
                	});
                },
                select: function(obj, record){
                	var grid = obj.up('grid')
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                   	var recordToBeUpdated = grid.getStore().findRecord('feePlanId',selectedRecord.data.feePlanId);
                   	if(!isNullOrEmpty(record[0].data.installmentPerMonth)){
                   		recordToBeUpdated.set('installmentPerMonth',record[0].data.installmentPerMonth);
                   	}else{
                   		recordToBeUpdated.set('installmentPerMonth','-');
                   	}
                   	if(!isNullOrEmpty(record[0].data.totalAmount)){
                   		recordToBeUpdated.set('totalAmount',record[0].data.totalAmount);
                   	}else{
                   		recordToBeUpdated.set('totalAmount','-');
                   	}
                   	if(!isNullOrEmpty(record[0].data.feePlanRuleId)){
                   		recordToBeUpdated.set('feePlanRuleId',record[0].data.feePlanRuleId);
                   	}
                   	recordToBeUpdated.set('feeRuleIdOnlyForEditAndView','');
                   	
                }
                
            },
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            		}
            	},
            	loadingText: getCommonTranslation('SEARCHING'),
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	getInnerTpl: function() {
            		return '<div class="search-item">' +
            		'{value}' +
            		'</div>';
            	}
            }
        },    
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				var isReadOnly = meta.column.getEditor().readOnly;       	
				return value;
			} else {
				if(showClickToEnter){
					meta.tdCls = 'gridInputCustomStyle'; 
					return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
				}else{
					return '';
				}
			}                        
		}
	}],
	plugins: {
		ptype : 'cellediting',
		clicksToEdit: 1
	}
});