/**
 * @Author Vidhi Shah
 */
Ext.define('Academia.view.personinfo.common.personalinfo.PermitDetailForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.permitdetailform',
	border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'permit_detail_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('PERMIT_TYPE'),
    		itemId : 'permitTypeItemId',
    		store:'personinfo.common.personalinfo.PermitTypeStore',
    		valueField : 'id',
    		displayField : 'value',
    		name : 'permitType',
			forceSelection :true,
			editable : false,
			typeAhead : false,
			hideTrigger:false,
			allowBlank: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('COUNTRY_OF_ISSUE'),
    		itemId : 'countryOfIssueItemId',
    		store:'common.CountryStore',
    		valueField : 'id',
    		displayField : 'countryName',
    		name : 'countryOfIssue',
			forceSelection :true,
			editable : false,
			typeAhead : false,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('CANTON_OF_ISSUE'),
    		itemId : 'cantonOfIssueItemId',
    		store:'personinfo.common.personalinfo.CantonOfIssueStore',
    		valueField : 'id',
    		displayField : 'value',
    		name : 'cantonOfIssue',
			forceSelection :true,
			editable : false,
			typeAhead : false,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype: 'checkboxfield',
			itemId : 'isPermitWithFamilyItemId',
			labelAlign: 'right',
			region: 'south',
			style:{marginTop:'25px'},
			boxLabel: getCommonTranslation('IS_PERMIT_WITH_FAMILY'),
			name: 'isPermitWithFamily',
			checked:false,
			inputValue: true,
			uncheckedValue: false
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('PERMIT_START_DATE'),
			itemId : 'permitStartDateItemId',
            name: 'permitStartDate',
            style:{marginTop:'17px'},
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		},{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('PERMIT_EXPIRATION_DATE'),
			itemId : 'permitExpirationDateItemId',
            name: 'permitExpirationDate',
            style:{marginTop:'17px'},
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		},{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('PERMIT_CANCELLATION_DATE'),
			itemId : 'permitCancellationDateItemId',
            name: 'permitCancellationDate',
            style:{marginTop:'17px'},
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		},{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('DATE_OF_DEPARTURE_ANNOUNCEMENT_TO_MIGRATION_OFFICE'),
			itemId : 'dateOfDepartureAnnouncementItemId',
            name: 'dateOfDepartureAnnouncement',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
	    }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype : 'textareafield',
			fieldLabel: getCommonTranslation('REASON_FOR_PERMIT_CANCELLATION'),
			itemId : 'reasonForPermitCancellationItemId',
            name: 'reasonForPermitCancellation',
            listener:{
    			blur:function(){}
    		}
        },{
        	xtype: 'datefield',
			fieldLabel: getCommonTranslation('DATE_SUBMITTED_TO_AUTHORITIES'),
			itemId : 'dateSubmittedToAuthoritiesItemId',
            name: 'dateSubmittedToAuthorities',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
        },{
			xtype : 'customcombobox',
    		fieldLabel : getCommonTranslation('METHOD_OF_SUBMISSION'),
    		itemId : 'methodOfSubmissionItemId',
    		store:'personinfo.common.personalinfo.PermitMethodOfSubmissionStore',
    		valueField : 'id',
    		displayField : 'value',
    		name : 'methodOfSubmission',
			forceSelection :true,
			editable : false,
			typeAhead : false,
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('DATE_ISSUED'),
			itemId : 'dateIssuedItemId',
            name: 'dateIssued',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'datefield',
			fieldLabel: getCommonTranslation('DATE_COLLECTED'),
			itemId : 'dateCollectedItemId',
            name: 'dateCollected',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
        },{
			xtype: 'checkboxfield',
			itemId : 'isPrimaryItemId',
			labelAlign: 'right',
			region: 'south',
			style:{marginTop:'25px'},
			boxLabel: getCommonTranslation('IS_PRIMARY'),
			name: 'isPrimary',
			checked:false,
			inputValue: true,
			uncheckedValue: false
		}]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'permitdocumentgrid',
			itemId:'permitdocumentgridItemId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'permiturldocumentgrid',
			itemId:'permiturldocumentgridItemId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantpermitdocumentgrid',
			itemId:'applicantpermitdocumentgridItemId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantpermiturldocumentgrid',
			itemId:'applicantpermiturldocumentgridItemId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'uploadPermitDoc',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadPermitDocItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'uploadPermitUrl',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'uploadPermitUrlItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
