Ext.define('Academia.view.personinfo.common.services.CommunityOptForm', {
    //extend: 'Ext.form.Panel',
    extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.communityoptform',
    itemId: 'communityOptForm',
    plugins: "formlabelrequired",
    border:false,    
    items: [{
        xtype: 'hidden',
        itemId: 'community_hidden_field',
        name: 'id'
    },{
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('COMMUNITY_NAME'),
            
            name: 'community',
            valueField: 'id',
            displayField: 'value',
            store: Ext.create('Academia.store.personinfo.common.services.CommunityNameStore'),
            editable: false,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN'),
            name: 'joiningDate',
            itemId :'startDate',
            allowBlank: false,
            //minValue: new Date(),
            vtype: 'daterange',
            endDateField: 'endDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_EXIT'),
            
            name: 'exitDate',
//            allowBlank: false,
            itemId : 'endDate',
            disabled : true,
            vtype: 'daterange',
            startDateField: 'startDate',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'fit',
        items: [{
            xtype: 'radiogroup',
            itemId: 'communityOptRadioGroup',
            labelWidth: 100,
            fieldLabel: getPersonModuleTranslation('COMMUNITY_OPT'),
            columns: 2,
            vertical: true,
            items: [{
                boxLabel: getPersonModuleTranslation('OPT_IN'),
                name: 'isOpted',
                itemId : 'optInRadioBtn',
                inputValue: true,
                checked : true
            }, {
                boxLabel: getPersonModuleTranslation('OPT_OUT'),
                name: 'isOpted',
                itemId :'optOutRadioBtn',
                inputValue: false
            }]
        	,listeners: {
                change: function(radiogroup, radio){
                    var visible = radio.isOpted == true;
                    var form = radiogroup.findParentByType('form');
                    var exitDate = form.down('#endDate');
                    if( !isNullOrEmpty(exitDate) ){
                    	exitDate.setDisabled(visible);
					}
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textareafield',
            name: 'remark',
            width : 460,
            fieldLabel: getPersonModuleTranslation('REMARK')
        }]

    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'communityOptCancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});