Ext.define('Academia.view.personinfo.common.services.HostelApplicationDetailsView', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hostelApplicationDetailsView',
    title: getHostelTranslation('HOSTEL_APPLICATIONS'),
    border: true,
    store:'servicerequest.HostelApplicationDetailsViewStore',
    autoScroll: false,
    height:'100%',
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store:'servicerequest.HostelApplicationDetailsViewStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'applyForHostel',
        text:getHostelTranslation('APPLY_FOR_HOSTEL'),
        tooltip:getHostelTranslation('APPLY_FOR_HOSTEL')
    }, {
    	   xtype: 'button',
           itemId: 'applyWaitingList',
           text:getHostelTranslation('APPLY_FOR_WAITING_LIST'),
           tooltip:getHostelTranslation('APPLY_FOR_WAITING_LIST')
    }, {
    	   xtype: 'button',
           itemId: 'revokeApplication',
           disabled:true,
           text:getHostelTranslation('REVOKE_APPLICATION'),
           tooltip:getHostelTranslation('REVOKE_APPLICATION')
    }],
    columns: [{
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        sortable: true,
        flex: .2,
    
    }, {
        header: getCommonTranslation('APPLIED_HOSTEL_CODE_NAME'),
        dataIndex: 'hostel',
        sortable: true,
        flex: .2,
        renderer:function(value, meta, record){
          if(!isNullOrEmpty(record.data.hosteCode)) {
              return record.data.hosteCode + ' '+record.data.hosteName;
          } 
        }
    }, {
        header: getCommonTranslation('APPLICATION_STATUS'),
        dataIndex: 'applicationStatus',
        sortable: true,
        flex: .2,
        renderer:function(value) {
			if(value == 'SUBMITTED' || value == 'Submitted'){
                return  getFeeAndPaymentCommonTranslation('SUBMITTED');
            }else if(value == 'REVOKED' || value == 'Revoked'){
                return  getFeeAndPaymentCommonTranslation('REVOKED');
            }else if(value == 'CANCELLED' || value == 'Cancelled'){
                return  getFeeAndPaymentCommonTranslation('CANCELLED');
            }else if(value == 'ALLOCATED' || value == 'Allocated'){
                return  getFeeAndPaymentCommonTranslation('ALLOCATED');
            }else if(value == 'UNALLOCATED' || value == 'Unallocated'){
                return  getFeeAndPaymentCommonTranslation('UNALLOCATED');
            }else if(value == 'ALLOTTED' || value == 'Allotted'){
                return  getHostelTranslation('ALLOTTED');
            }else if(value == 'CHECKED_IN' || value == 'Checked In'){
                return getHostelTranslation('CHECKED_IN');
            }else if(value == 'CHECKED_OUT' || value == 'Checked Out'){
                return getHostelTranslation('CHECKED_OUT');
            }else {
            	return '';
            }
		}
    },{
        header: getCommonTranslation('ALLOCATED_HOSTEL'),
        dataIndex: 'allocatedHostel',
        sortable: true,
        flex: .2,
        /*
		 * renderer: function(obj) { return columnObjRender(obj, 'value'); }
		 */
    }, {
        header: getCommonTranslation('APPLICATION_TYPE'),
        dataIndex: 'applicationType',
        sortable: true,
        flex: .2,
    	renderer:function(value){
			if(value == 'WAITING_LIST_SETUP'){
				return  getFeeAndPaymentCommonTranslation('WAITING_LIST_APPLICATION');
			}else if(value == 'HOSTEL_GENERAL_SETUP'){
				return getFeeAndPaymentCommonTranslation('GENERAL_APPLICATION');
			}else {
				return '';
			}
		}
        
    }, {
        header: getCommonTranslation('HOSTEL_CONFIGURATION_ID_NAME'),
        dataIndex: 'waitingListType',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'hostelApplicationYear',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('WANT_TO_REALLOCATE_SAME_HOSTEL'),
        dataIndex: 'isReallocateSameHostel',
        sortable: true,
        flex: .2,
        renderer:function(value) {
        	if(value == true){
                return getFeeAndPaymentCommonTranslation('YES')
            }else{
		         return getFeeAndPaymentCommonTranslation('NO')        			       
		    }
        }
    }]
});
