Ext.define('Academia.view.personinfo.common.services.ServiceOptForm', {
    //extend: 'Ext.form.Panel',
    extend:'Academia.view.common.DynamicFieldForm',
    alias: 'widget.serviceoptform',
    itemId: 'serviceOptForm',
    plugins: "formlabelrequired",
    border:false,    
    items: [{
        xtype: 'hidden',
        itemId: 'service_hidden_field',
        name: 'id'
    },{
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'hidden',
        itemId: 'billedUserTypeHiddenField',
        name: 'billedUserType'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('SERVICE_NAME'),
            itemId: 'serviceNameComboField',
            name: 'service',
            valueField: 'id',
            displayField: 'value',
            store: Ext.create('Academia.store.personinfo.common.services.ServiceNameStore'),
            editable: false,
            allowBlank: false
        }, /*{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('SERVICE_IDENTIFIER'),
            
            name: 'serviceIdentifier',
            allowBlank: false
        }*/]
    }, {

        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('START_DATE'),
            
            name: 'fromDate',
            itemId : 'startDate',            
            allowBlank: false,
            vtype: 'daterange',
            endDateField: 'endDate',
            //minValue: new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
            
        },{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('END_DATE'),
            name: 'tillDate',
            allowBlank: false,
            itemId : 'endDate',
            //disabled : true,
            vtype: 'daterange',
            startDateField: 'startDate',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('FEE_PLAN'),
            itemId: 'feePlanComboField',
            name: 'feePlan',
            queryMode: 'local',
            valueField: 'id',
            displayField: 'value',
            overrideSetValue:false, 
            store: 'personinfo.common.services.FeePlanStore',
            editable: false,
            allowBlank: false
        }, {
        	 xtype: 'nestedJsonCombo',
             fieldLabel: getPersonModuleTranslation('FEE_PLAN_RULE'),
             itemId: 'feePlanRuleComboField',
             disabled:true,
             name: 'feePlanRule',
             queryMode: 'local',
             valueField: 'id',
             displayField: 'value',
             overrideSetValue:false, 
             store: 'feeandpayment.managebill.BillSequence',
             editable: false,
             allowBlank: false
        }]

    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getPersonModuleTranslation('FEE_PLAN_STAGE'),
            itemId: 'feePlanRuleStageComboField',
            name: 'feePlanRuleStage',
            disabled:true,
            queryMode: 'local',
            valueField: 'id',
            displayField: 'value',
            overrideSetValue:false, 
            store: 'feeandpayment.managebill.FeePlanStage',
            editable: false,
            allowBlank: false
        }, {
            xtype: 'numberfield',
            itemId: 'amountPaidComboField',
            fieldLabel: getPersonModuleTranslation('AMOUNT_TO_BE_PAID'),
            name: 'amountToBePaid',
            minValue: 0,
            readOnly: true,
            allowBlank: false
        }]

    }, /*{
        xtype: 'fieldcontainer',
        layout: 'fit',
        items: [{
            xtype: 'radiogroup',
            labelWidth: 80,
            itemId: 'serviceOptRadioGroup',
            name: 'isOpted',
            fieldLabel: getPersonModuleTranslation('SERVICES_OPT'),
            columns: 2,
            vertical: true,
            items: [{
                boxLabel: getPersonModuleTranslation('OPT_IN'),
                itemId : 'optInRadioBtn',
                name: 'isOpted',
                inputValue: true,
                checked: true
            }, {
                boxLabel: getPersonModuleTranslation('OPT_OUT'),
                itemId : 'optOutRadioBtn',
                name: 'isOpted',
                inputValue: false
            }]
        }]
    }*/,{
        xtype: 'checkboxfield',
        width: 'auto',
        labelAlign: 'right',
        itemId:'isOpted',
        boxLabel: getPersonModuleTranslation('OPT_OUT'),
        name: 'isOpted',
        inputValue : false,
        uncheckedValue: true,
        hidden:true
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textareafield',
            name: 'remarks',
            itemId:'remarks',
            width : 460,
            fieldLabel: getPersonModuleTranslation('REMARK')
        }]

    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});