/**
 * @author Amit G 
 */
Ext.define('Academia.view.personinfo.dashlet.AdmissionIDDetailDashlet', {
	extend : 'Academia.view.personinfo.dashlet.PersonInfoDashboardDashlet',
	alias : 'widget.admissioniddetaildashlet',
	graphView:true,
	layout:'card',
	activeItem: 0, 
	cls:'StudentD365DashletCLS dashlet',
	loadPersonInfoDashboard :function(){
		var this$=this;
		var view= this$.layout.getActiveItem();
		var store= view.getStore();
		var studentProfile = this$.up('studentprofile');
		var studentId = studentProfile.getUserId();
		store.getProxy().extraParams = {
			studentId: studentId
		};
		store.load();
	},
	items:[{
		xtype:'griddashletgetmethod',
		width: '100%',
		height: 'auto',
		fields : [ 'admissionCode', 'admissionId', 'admissionStatus', 'inactiveReason', 'programName', 'batchName'],
		url : SERVERURL.PATH_FIND_ADMISSION_DETAIL_FOR_DASHLET,
		itemId: 'admissionDetailDashletGrid',
		border:1,
		columns:[{
			header : getCommonTranslation('ADMISSION_ID'),
			dataIndex : 'admissionId',
			flex:.2
		},{
			header : getCommonTranslation('ADMISSION_ID_STATUS'),
			dataIndex : 'admissionStatus',
			flex:.2
		},{
			header : getCommonTranslation('ID_INACTIVE_REASON'),
			dataIndex : 'inactiveReason',
			flex:.2
		},{
			header : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			flex:.2
		},{
			header : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex:.2
		}]
	}]
});
