
Ext.define('Academia.view.personinfo.dashlet.PersonInfoDashboardDashlet', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.personinfodashboarddashlet',
	params:{},
	collapsible:true,
	frame : true,
	resizable : true,
	resizeHandles :'e s se',
	draggable: true,
	align : 'stretch',
	cls:'dashlet',
	style:{
		'float' : 'left'
	},
	graphView:false,
	width: 500,
	height: 150,
	loadPersonInfoDashboard :function(){
		console.log('No loadDashlet method');
	},
	getParams :function(){
		var extraParam=this.params,responceObject={};
		for(var propt in extraParam){
			if (extraParam.hasOwnProperty(propt) && extraParam[propt]) {
				responceObject[propt]=extraParam[propt];
			}
		}
		var toolbar = this.up('personinfodashboardhomepage').down('toolbar');

		var dates=toolbar.down('#dateRangePicker').getValues();
		for(var propt in dates){
			if (dates.hasOwnProperty(propt) && dates[propt]) {
				responceObject[propt]=dates[propt];
			}
		}
		return responceObject;	
	},

	tools:[{
		xtype: 'tool',
		type: 'refresh',
		tooltip :getCommonTranslation('CLICK_TO_REFRESH'),
		renderTpl: [ '<img   src="resources/images/icon-refresh.svg"/>' ],
		handler: function(e, target, header, tool){
			var portlet = header.ownerCt;
			portlet.loadPersonInfoDashboard();
			portlet.setLoading('Loading...');
			Ext.defer(function() {
				portlet.setLoading(false);
			}, 1000);
		}
	},{
		xtype: 'button',
		itemId: 'extraBtns',
		hidden:true,
		menu: []
	}],

	listeners:{
		move:function( panel, x, y, eOpts ){
			panel.el.dom.style.left = '';
			panel.el.dom.style.top = '';
		},
		afterrender:function(this$){
			this$.loadPersonInfoDashboard();
		}
	},

	addExportToPdf:function(panel,grid){
		var exportToPDF={
				text: 'Export To Pdf',
				itemId: 'exportToPdf',
				handler: function(btn, target, header, tool){
					grid.exportAllGridData(grid,true,false);  
				}
		};
		this.addMenu(exportToPDF,panel);
	},

	removeExportToPdf:function(panel){	
		this.removeMenu('exportToPdf',panel);
	},

	addExportToExcel:function(panel,grid){
		var exportToExcel={
				text: 'Export To Excel',
				itemId: 'exportToExcel',
				handler: function(btn, target, header, tool){
					grid.exportAllGridData(grid,false,true);  
				}
		};
		this.addMenu(exportToExcel,panel);
	},

	removeExportToExcel:function(panel){	
		this.removeMenu('exportToExcel',panel);
	},

	addExportToPng:function(panel,chart){
		var exportToExcel={
				text: 'Export To Png',
				itemId :'exportToPng',
				handler: function(btn, target, header, tool){
					chart.save({
						type: 'image/png'
					});
				}
		};
		this.addMenu(exportToExcel,panel);
	},

	removeExportToPng:function(panel){	
		this.removeMenu('exportToPng',panel);
	},

	addMenu:function(menu,panel){
		if(!panel)
			panel=this;
		var menuBtn = panel.header.down('#extraBtns'),menuPanel = menuBtn.menu;
		menuBtn.setVisible(true);
		menuPanel.add(menu);
	},

	removeMenu:function(itemId,panel){
		if(!panel)
			panel=this;
		var menuBtn = panel.header.down('#extraBtns'),menuPanel = menuBtn.menu,menu=menuPanel.down('#'+itemId);
		menuPanel.remove(menu);
		if(menuPanel.items.length==0)
			menuBtn.setVisible(false);
	},
	/**
	 * add graph view button (image) 
	 */
	addGraphViewButton:function(panel){
		var graphButton = {
				tooltipFlag : 0,
				itemId: 'graphViewBtn',
				tooltip :getCommonTranslation('SHOW_CHART_VIEW'),
				renderTpl: [ '<img   src="resources/images/icon-graph.svg"/>' ],
				handler: function(btn, target, header, tool){
					var this$ = header.ownerCt;
					header.ownerCt.getLayout().setActiveItem(this$.activeTab);
					this$.params={};
					this$.loadPersonInfoDashboard();
				}
		};
		panel.header.insert(2,graphButton);
	},
	/**
	 * This method is use to get the logged in user.
	 */
	/*getCurrentlyLoggedInDashletSPUser:function() {
		var userInfo = Academia.model.authentication.UserInfoModel;
		var user = { 
				id: userInfo.get('studentId'),
				value:userInfo.get('userName'),
				code:userInfo.get('code')
				//TODO:Please confirm with other while changing generic methods other functionality might break due to this.
				//portalId:userInfo.get('portalId')
				//personId: userInfo.get('personId')
		};
		return user;
	},*/
	/**
	 * add grid view button (Image)
	 */
	addGridViewButton:function(panel){
		var gridButton = {
				itemId: 'gridViewBtn',
				tooltip :getCommonTranslation('SHOW_GRID_VIEW'),
				renderTpl: [ '<img   src="resources/images/icon-list.svg"/>' ],
				handler: function(btn, target, header, tool){
					var this$ = header.ownerCt;
					header.ownerCt.getLayout().setActiveItem(this$.activeTab);
					this$.params={};
					this$.loadPersonInfoDashboard();
				}
		};
		panel.header.insert(2,gridButton);
	},
	/**
	 * remove grid/graph view button
	 */
	removeMenuButtons:function(itemId,panel){
		var btn = panel.header.down('#'+itemId);
		panel.header.remove(btn);
	},

	removeGridViewButton:function(panel){	
		this.removeMenuButtons('gridViewBtn',panel);
	},
	removeGraphViewButton:function(panel){
		this.removeMenuButtons('graphViewBtn',panel);
	},/**
 	 * resetPageSetting used for reseting 
 	 *  page and start params for pagination
 	 */
 	resetPageSetting:function(store){
 		if(store){
 			store.currentPage = 1;
 			store.getProxy().setExtraParam('sort', null);
 		}
 	}
});
