/**
 * @author Priyanshi Sharma
 */

Ext.define('Academia.view.personinfo.student.DownloadStudentHolds',{
	extend: 'Ext.form.FormPanel',
	alias: 'widget.downloadstudentholds',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
//	cls:'customSearchPanel',
	/*defaults: {
		width: 226,
		labelAlign: 'top'
	},*/
	plugins : "formlabelrequired",
	items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'templateFor',
            itemId: 'templateFor',
            fieldLabel: getCommonTranslation('TEMPLATE_FOR'),
            editable: false,
            queryMode: 'local',
            store:'student.managehold.TemplateForStore',
            displayField: 'name',
            valueField: 'id',
            allowBlank:false,
            value:'Apply Hold',
        }]
	},{
		xtype:'fieldcontainer',
		itemId:'holdProgramBatchContainerId',
		items:[{
			xtype : 'fieldcontainer',
			width: '100%',
			itemId:'holdProgramBatchContainer',
			layout : 'hbox',
			defaults: {
				labelAlign: 'top'
			},
			items : [{
				xtype: 'customcombobox',
                name: 'PROGRAM_NAME',
                itemId: 'holdProgram',
                fieldLabel: getCommonTranslation('PROGRAM'),
                valueField: 'id',
                displayField: 'value',
                width:410,
                minChars:3,
                queryParam:'programName',
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                listeners: {
                    render: function(combo) {
                    	var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                        combo.bindStore(store);
                    },
                    select:function(obj,record){
	                    	
	                    	var programId = record[0].get("id");
	                    	var  batch = obj.nextSibling();
	                    	var  seatType = batch.nextSibling();
	                    	
	                    	batch.setDisabled(false);
	                    	batch.reset();
	                    	
	                    	seatType.setDisabled(true);
	                    	seatType.reset();
	                    	
	                    	var store = batch.getStore();
	                    	
                       	store.proxy.extraParams = {
      							 id : programId
      					};
                       	store.load();	                    	
	                    }
                },
                    listConfig: {
    	 				listeners: {
    						beforeshow: function(picker) {
    							picker.minWidth = picker.up('combobox').getSize().width;
    						}
    					},
    	 				loadingText: getCommonTranslation('SEARCHING'),
    	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	 				getInnerTpl: function() {
    	 					return '<div class="search-item">' +
    	 					'{value}' +
    	 					'</div>';
    	 				}
    	 			}
			},{
				xtype: 'customcombobox',
                name: 'BATCH_NAME',
                itemId: 'holdBatch',
                fieldLabel: getCommonTranslation('BATCH'),
                disabled:true,
                editable: false,
                queryMode: 'local',
                displayField: 'value',
                valueField: 'id',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                        combo.bindStore(store);
                    },
                    select:function(obj,record){
	                    	var batchId = record[0].get("id");
 	                    	var  seatType = obj.nextSibling();
 	                    	
 	                    	seatType.setDisabled(false);
 	                    	seatType.reset();
 	                    	
 	                    	var store = seatType.getStore();
 	                    	
                           	store.proxy.extraParams = {
                           			batchId : batchId
          					};
                           	store.load();
 	                    	
 	                    }
                }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('SEAT_TYPE'),
				width: 226,
				labelAlign: 'top',
				name : 'seatType',
				itemId : 'holdSeatTypeId',
				store:Ext.create('Academia.store.common.SeatTypesByBatchId'),
				valueField: 'seatTypeId',
	    		displayField: 'seatTypeName',
				typeAhead : true,
				queryParam:'qry',
				disabled:true,
				forceSelection : true
			},{
				xtype: 'button',
				itemId: 'addRowBtn',
				cls: 'CustomBodyBtnSettings',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				}
			  }]
			}]},{
		xtype: 'fieldcontainer',
		style:{marginTop:'23px !important',marginLeft:'-5px !important'},
		items: [{
			xtype:'button',
			itemId:'studentHoldTemplateDownload',
			text:getFeeAndPaymentCommonTranslation('DOWNLOAD_RECEIPTS_TEMPLATE'),
			ui: 'CustomBtnSubmit',
			//formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId:'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});
