/**
 * @author <a href="vidhi.shah@serosoft.in">Vidhi Shah</a>
 *
 */
Ext.define('Academia.view.personinfo.student.FunctionaryDetailsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.functionarydetailsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'functionary_details_hidden_field',
        name: 'id'
    },{
        xtype: 'hidden',
        itemId: 'admission_hidden_field',
        name: 'admId'
    }, {
        xtype: 'hidden',
        itemId: 'admission_hidden_field',
        name: 'admId'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('FUNCTIONARY_TYPE'),
            store: 'common.FunctionaryTypeStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'functionaryTypeItemId',
            name: 'functionaryType',
            allowBlank: false,
            editable: false
        }, {
        	xtype: 'customcombobox',
			name: 'functionaryUserId',
			itemId:'functionaryUserIdItemId',
			fieldLabel: getPersonModuleTranslation('FUNCTIONARY_ID_NAME'),
			store:'scholarships.ScholarshipOwnersStore',
			valueField: 'id',
			forceSelection:true,
			displayField: 'value',
			queryParam:'qry',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			allowBlank: false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            		}
            	},
            	loadingText: getCommonTranslation('SEARCHING'),
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'textfield',
        	fieldLabel: getPersonModuleTranslation('FUNCTIONARY_ROLE'),
            itemId: 'functionaryUserRoleItemId',
            name: 'functionaryUserRole',
            allowBlank: true,
            hidden:true
        },{
        	xtype: 'numberfield',
            name: 'functionaryInvolvementInPercentage',
            itemId: 'functionaryInvolvementInPercentageItemId',
            fieldLabel: getPersonModuleTranslation('FUNCTIONARY_INVOLVEMENT_IN_PERCENTAGE'),
            allowBlank: false,
            minValue: 1,
            maxValue: 100,
            maxLength: 3,
            allowDecimals:false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('OU_DEPARTMENT'),
            store: 'common.OUDepartmentStore',
            valueField: 'id',
            displayField: 'value',
            itemId: 'oUDepartmentItemId',
            name: 'oUDepartment',
            allowBlank: true,
            editable: false
        },{
        	xtype: 'textfield',
        	fieldLabel: getCommonTranslation('FUNCTIONARY_DEPARTMENT'),
            itemId: 'functionaryDepartmentItemId',
            name: 'functionaryDepartment',
            allowBlank: true,
            readOnly : true
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('START_DATE'),
            itemId: 'startDateItemId',
            name: 'startDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            vtype : 'daterange',
            endDateField : 'endDateItemId'
        },{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('END_DATE'),
            itemId: 'endDateItemId',
            name: 'endDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            vtype : 'daterange',
            startDateField : 'startDateItemId'
        }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [ {
        	xtype: 'statusCombo',
            name: 'activeStatus',
            allowBlank: false,
            itemId: 'activeStatusItemId',
            editable: false,
            fieldLabel: getPersonModuleTranslation('STATUS')
        },{
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('AUDIT_DATE'),
            itemId: 'auditDateItemId',
            name: 'auditDate',
            editable : false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            vtype : 'daterange'
        }]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [ {
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AUDIT_ID'),            
            itemId: 'auditIdItemId',
            name: 'auditId',
            readOnly : true,
            allowBlank: false
        },{
        	xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('ADMISSION_ID'),            
            itemId: 'admissionIdItemId',
            name: 'admissionId',
            //readOnly : true,
            itemId: 'admissionIdItemId',
            valueField: 'admissionID',
			displayField: 'admissionCode',
			forceSelection:true,
            store: 'common.StudentAdmissionIdStore',
            allowBlank: true,
            editable : true,
            matchFieldWidth:true

            
        
		}]
    },{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [ {
        	xtype: 'textareafield',
            fieldLabel: getPersonModuleTranslation('DESCRIPTION'),
            name: 'description',
            allowBlank: true,
            itemId: 'descriptionItemId',
            enableKeyEvents: true,
            width:460
        }]
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE
		}]
    }]
});
