/**
 *  @author Priyanshi sharma
 */

Ext.define('Academia.view.personinfo.student.ManageHoldsMappedProgramGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageholdsmappedprogramgrid',
	store: 'student.managehold.ManageHoldMappingGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.managehold.ManageHoldMappingGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation('ACADEMY'),
		dataIndex: 'academyName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('LOCATION'),
		dataIndex: 'locationName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'period',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SEAT_NAME'),
		dataIndex: 'seatTypeName',
		flex:1,
		sortable:true
	}]
});