/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.personinfo.student.StudentGraduationCeremonyForm',{
	extend:'Ext.form.Panel',
	autoScroll:true,
	alias:'widget.studentGraduationCeremonyForm',
	plugins: "formlabelrequired",
	items:[{
		xtype: 'customcombobox',
		name: 'ceremonyName',
		itemId:'ceremonyName',
		labelAlign : 'top',
		fieldLabel: getCommonTranslation('CEREMONY_NAME'),
		store: 'student.studentprofile.GraduationCeremonyNameStore',
		valueField: 'id',
		displayField: 'ceremonyName',
		allowBlank: false,
		typeAhead:true,
		forceSelection:true,
		width: 226
	},{
		xtype : 'radiogroup',
		itemId:'attendGraduationCermonyId',
		labelAlign : 'top',
		allowBlank: false,
		fieldLabel:getCommonTranslation('ATTEND_GRADUATION_CEREMONY'),
		items : [{
			boxLabel : getFeeAndPaymentCommonTranslation('YES'),
			name:'attendGraduationCermony',
			inputValue : true,
			checked : true
		},{
			boxLabel : getFeeAndPaymentCommonTranslation('NO'),
			name:'attendGraduationCermony',	
			inputValue : false
		},{
			boxLabel : getCommonTranslation('DEFFERED_TO_MARCH'),
			name:'attendGraduationCermony',	
			itemId:'defferedToMarch',
			inputValue : 'DEFFERED_TO_MARCH'
		}]
	}, {
        xtype: 'fieldcontainer',
        layout:'hbox',
        items: [{
    		xtype: 'customcombobox',
    		name: 'choicesId',
    		itemId:'choicesId',
    		labelAlign : 'top',
    		fieldLabel: getCommonTranslation('CHOICES'),
    		store: Ext.create('Ext.data.Store', {
    		    fields: ['id', 'value'],
    		    data : [
    		        {"id":"SELF_COLLECT_DEGREE_CERTIFICATE", "value":getCommonTranslation('SELF_COLLECT_DEGREE_CERTIFICATE')},
    		        {"id":"COURIER_DEGREE_CERTIFICATE", "value":getCommonTranslation('COURIER_DEGREE_CERTIFICATE')}
    		    ]
    		}),
    		valueField: 'id',
    		displayField: 'value',
    		allowBlank: false,
    		typeAhead:true,
    		hidden:true,
    		disabled:true,
    		forceSelection:true,
    		width: 226,
    	},{
    		xtype: 'customcombobox',
    		name: 'addressId',
    		itemId:'addressId',
    		labelAlign : 'top',
    		fieldLabel: getCommonTranslation('ADDRESS'),
    		store: 'student.studentprofile.GraduationCermonyAddressStore',
    		valueField: 'personAddressId',
    		displayField: 'displayVal',
    		allowBlank: false,
    		typeAhead:true,
    		hidden:true,
    		disabled:true,
    		forceSelection:true,
    		width: 226,
    	//	queryMode:'local'
    	}]
    },, {
        xtype: 'fieldcontainer',
        layout:'hbox',
        items: [{
        	xtype: 'textareafield',
    		name: 'addressManually',
    		itemId: 'addressManually',
    		labelAlign : 'top',
    		maxLength : 1000,
            enforceMaxLength : true,
            allowBlank: false,
            hidden:true,
            disabled:true,
    		fieldLabel: getCommonTranslation('ENTER_ADDRESS_MANUALLY'),
    		width: 226
    	}, {
    		xtype: 'textareafield',
    		name: 'remark',
    		itemId: 'remark',
    		labelAlign : 'top',
    		maxLength : 1000,
            enforceMaxLength : true,
            hidden:true,
            disabled:true,
    		fieldLabel: getCommonTranslation('ABSENT_REASON'),
    		width: 226,
    	}]
    } ,{
    	xtype: 'displayfield',
    	itemId:'dateAbsentiaPassed',
        value: '<span style="color:red">'+getCommonTranslation('Dateabsentia_has_been_passed')+'<\span>',
        hidden:true
    },{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
