/**
 * Student Enrollment form with search REsult Grid
 */
Ext.define('Academia.view.personinfo.student.StudentMasterEnrollmentGenerationForm', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentmasterenrollmentgenerationform',
	frame: false,
	method : 'POST',
	//cls:'customSearchPanel',
	standardSubmit : false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        items: [{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 226
        	},
        	items: [{
        		xtype: 'customcombobox',
        		name: 'PROGRAM_NAME1',
        		itemId: 'programId1',
        		fieldLabel: getPersonModuleTranslation('PROGRAM'),
        		editable: false,
        		valueField: 'id',
        		displayField: 'value',
        		allowBlank:false,
        		listeners: {
        			render: function(combo) {
        				var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
        				combo.bindStore(store);
        			},
        			select:function(obj,record){

        				var programId = record[0].get("id");
        				var  batch = obj.nextSibling();
        				var  period = batch.nextSibling();

        				batch.setDisabled(false);
        				batch.reset();

        				period.setDisabled(true);
        				period.reset();

        				var store = batch.getStore();

        				store.proxy.extraParams = {
        						id : programId
        				};
        				store.load();
        			}
        		}
        	},{
        		xtype: 'customcombobox',
        		name: 'BATCH_NAME1',
        		itemId: 'batchId1',
        		fieldLabel: getPersonModuleTranslation('BATCH'),
        		disabled:true,
        		editable: false,
        		displayField: 'value',
        		valueField: 'id',
        		allowBlank:false,
        		listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                        combo.bindStore(store);
                    },
                    select:function(obj,record){
                    	var batchId = record[0].get("id");
                    	var  period = obj.nextSibling();
                    	
                    	period.setDisabled(false);
                    	period.reset();
                    	
                    	var store = period.getStore();
                    	
                      	store.proxy.extraParams = {
     							 id : batchId
     					};
                      	store.load();
                    	
                    }
                }
        	},{
        		xtype: 'customcombobox',
        		itemId:'periodId1',
        		name: 'PERIOD_NAME1',
        		fieldLabel: getPersonModuleTranslation('PERIOD'),
        		disabled:true,
        		editable: false,
        		displayField: 'value',
        		valueField: 'id',
        		allowBlank:false,
        		listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                        combo.bindStore(store);
                    }
                }        		
        	}]
        }, {
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 226
        	},
        	items: [{
        		xtype: 'customcombobox',
        		name: 'PROGRAM_NAME2',
        		itemId: 'programId2',
        		fieldLabel: getPersonModuleTranslation('PROGRAM'),
        		store:'common.ProgramByAcAndLoIdStore',
        		editable: false,
        		valueField: 'id',
        		displayField: 'value',
        		allowBlank:false,
        		listeners: {
        			render: function(combo) {
        				var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
        				combo.bindStore(store);
        			},
        			select:function(obj,record){

        				var programId = record[0].get("id");
        				var  batch = obj.nextSibling();
        				var  period = batch.nextSibling();

        				batch.setDisabled(false);
        				batch.reset();

        				period.setDisabled(true);
        				period.reset();

        				var store = batch.getStore();

        				store.proxy.extraParams = {
        						id : programId
        				};
        				store.load();
        			}
        		}
        	},{
        		xtype: 'customcombobox',
        		name: 'BATCH_NAME2',
        		itemId: 'batchId2',
        		fieldLabel: getPersonModuleTranslation('BATCH'),
        		store:'program.programbatchdetail.BatchStore',
        		disabled:true,
        		editable: false,
        		//queryMode: 'local',
        		displayField: 'value',
        		valueField: 'id',
        		allowBlank:false,
        		listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                        combo.bindStore(store);
                    },
                    select:function(obj,record){
                    	var batchId = record[0].get("id");
                    	var  period = obj.nextSibling();
                    	
                    	period.setDisabled(false);
                    	period.reset();
                    	
                    	var store = period.getStore();
                    	
                      	store.proxy.extraParams = {
     							 id : batchId
     					};
                      	store.load();
                    	
                    }
                }
        	},{
        		xtype: 'customcombobox',
        		itemId:'periodId2',
        		name: 'PERIOD_NAME2',
        		disabled:true,
        		editable: false,
        		displayField: 'value',
        		valueField: 'id',
        		fieldLabel: getPersonModuleTranslation('PERIOD'),
        		allowBlank:false,
        		listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                        combo.bindStore(store);
                    }
                }
        	}]
        }, {
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width: 226
        	},
        	items: [{
        		xtype: 'textfield',
        		name: 'collegeNo',
        		itemId: 'collegeNo2',
        		allowBlank:false,
        		fieldLabel: getPersonModuleTranslation('COLLEGE_NO')
        	},{
        		xtype: 'numberfield',
        		name: 'padding',
        		itemId: 'paddingId',
        		allowBlank:false,
        		fieldLabel: getPersonModuleTranslation('PADDING'),
        		minValue:0
        	}]
        }, {
        	xtype: 'fieldcontainer',
        	width: '100%',
        	items: [{
        		xtype: 'button',
        		text: getPersonModuleTranslation('GENERATE_ENROLLMENT'),
        		itemId: 'generateEnrollmentButtonId',
        		buttonAlign: 'right',
        		ui: 'CustomBtnSubmit',
        		formBind:true,
        		scale: CONSTANTS.BUTTONSIZE
        	},{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCommonTranslation("RESET"),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
        }]
    }]
});