/**
 * @author Amit G
 * 
 */
Ext.define('Academia.view.personinfo.student.StudentProgramWiseConditionsAdmissionAdmGrid', {
	 extend: 'Ext.grid.Panel',
	alias : 'widget.studentprogramwiseconditionsadmissionadmgrid',
    title: getAdmissionTranslation('QUALIFICATION_BEING_APPLIED_FOR'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE') ,
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.callParent(arguments);
    },
	columns : [{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academy.value',
		flex : 1
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'location.value',
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'program.value',
		flex :1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
			
		}
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex:'batch.value',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex : 'modeOfDelivery.value',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex : 'batchPartTime',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				if(value){
					return 'Part Time'
				}else{
					return 'Full Time'
				}
			}else{
				return '-';
			}
		}
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType.value',
		flex : 1,
		renderer : function(value){
			if(!isNullOrEmpty(value)){
				return value;	
			}else{
				return '-';
			}
		}
	}],
	buildStore: function() {
        return Ext.create('Academia.store.student.studentprofile.StoStudentProgramConditionDetailStore');
    }
});