/**
 *  Dharmendra.p
 */

Ext.define('Academia.view.personinfo.student.VoterPoolWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.voterpoolwindow',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('VOTER_POOL'),
	maxHeight:600,
	items: [{
		xtype: 'form',
		method: 'POST',
		autoScroll:true,
		margin: 0,
		bodyPadding: '10 10 10 10',
		layout: 'anchor',
		standardSubmit: false,
		plugins:"formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 226,
//			anchor: '100%'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'voterPool',
			itemId: 'voterPoolItemId',
			store:'election.election.ElectionVoterPoolCodeNameStore',
			fieldLabel: getCommonTranslation('ELECTION_CODE_NAME'),
			valueField: 'id',
			displayField:'valueCode',
			allowBlank: false,
			forceSelection: true,
			editable: false,
			listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.maxWidth = picker.up('combobox').getSize().width;
    				}
    			}
    		
    		}
		},{
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				handler :function(button) {
					button.up('window').close();
				}
			}]
		}]
	}]
});