/**
 * @author Priyanshi Sharma
 * 
 */
Ext.define('Academia.view.placement.PlacementDetailReport.PlacementDetailReportFilters', {
	extend: 'Ext.form.Panel',
	alias: 'widget.placementdetailreportfilters',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
            xtype: 'customcombobox',
            name: 'intakeYearPlcDetailId',
            itemId: 'intakeYearPlcDetailItemId',
            fieldLabel: getCommonTranslation('INTAKE_YEAR'),
            store: Ext.create('Academia.store.common.IntakeYearStore'),
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            forceSelection: true,
            editable: false,
		},{
			xtype: 'customcombobox',
			name: 'placementcampus',
			itemId:'placementcampusPlcDetailItemId',
			store: Ext.create('Academia.store.placement.placementcampus.PlacementCampusStore'),
			fieldLabel: getPlacementTranslation('PATH_PLACEMENT_CAMPUS_CODE_CAMPUS'),
    	    emptyText: getCommonTranslation('ENTER_CHAR_TO_AUTO_SEARCH'),
    	    displayField:'valueCode',
			valueField:'id',
			editable: true,	    
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'placementType',
			itemId:'placementTypeItemId',
			store: Ext.create('Academia.store.placement.PlacementTypeStore'),
			fieldLabel: getPlacementTranslation('PLACEMENT_TYPE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'academyLocationName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [
		        {
		        	xtype: 'fieldcontainer',
		        	width: 'auto',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 226,
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        		xtype: 'nestedJsonCombo',
		        		name:'campusCoordinatorPlcId',
		        		itemId:'campusCoordinatorPlcItemId',
		        		store: Ext.create('Academia.store.placement.placementcampus.placementCampusCoordinatorStore'),
		        		fieldLabel : getPlacementTranslation('PLACEMENT_CAMPUS_COORDINATOR'),
		        		valueField: 'id',
		        		displayField: 'valueCode',
		        		queryParam:'name',
		    			minChars:3,
		    			typeAhead:false,
		    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    			enableKeyEvents  : 'true',
		    			hideTrigger:false,
		    			forceSelection:true,
		    			width:226,
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			}
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'academyLocationPlcId',
		        		itemId:'academyLocationPlcItemId',
		        		store: Ext.create('Academia.store.placement.placementcampus.PlacementCampusRecOrgALStore'),
		        		allowBlank:true,
		        		fieldLabel: getPlacementTranslation('RECRUITING_ORGANIZATION'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		queryParam:'academyLocationName',
		    			minChars:3,
		    			typeAhead:false,
		    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    			enableKeyEvents  : 'true',
		    			hideTrigger:false,
		    			forceSelection:true,
		    			width:226,
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			}
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'organizingAcademyLocationPlcId',
		        		itemId:'organizingAcademyLocationPlcItemId',
		        		store: Ext.create('Academia.store.placement.placementcampus.placementCampusOrgAlStore'),
		        		allowBlank:true,
		        		fieldLabel: getPlacementTranslation('CAMPUS_LOCATION'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		queryParam:'academyLocationName',
		    			minChars:3,
		    			typeAhead:false,
		    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		    			enableKeyEvents  : 'true',
		    			hideTrigger:false,
		    			forceSelection:true,
		    			width:226,
		    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    			listConfig: {
		    				listeners: {
		    					beforeshow: function(picker) {
		    						picker.minWidth = picker.up('combobox').getSize().width;
		    					}
		    				},
		    				loadingText: getCommonTranslation('SEARCHING'),
		    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    				getInnerTpl: function() {
		    					return '<div class="search-item">' +
		    					'{value}' +
		    					'</div>';
		    				}
		    			}
		        	}]	
		        },{
		        	xtype: 'fieldcontainer',
		        	width: 'auto',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 226,
		        		labelAlign: 'top'
		        	},
		        	items: [{
		        		xtype: 'nestedJsonCombo',
		        		name: 'programName',
		        		itemId:'programPlcItemId',
		        		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		        		store: Ext.create('Academia.store.common.ProgramByAcademyLocationStore'),
		        		allowBlank:true,
		        		valueField: 'id',
		        		displayField: 'valueCode',
		        		disabled:true,
		        		enforceMaxLength : true,
		        		maxLength:255,
		        		regex: /[a-zA-Z0-9]+/,
		        		typeAhead: true,
		                forceSelection: true,
		                triggerAction: 'all',
		                queryParam:'programName',
		                minChars:3,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 			listConfig: {
			 				listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
			 				loadingText: getCommonTranslation('SEARCHING'),
			 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			 				getInnerTpl: function() {
			 					return '<div class="search-item">' +
			 					'{value}' +
			 					'</div>';
			 				}
			 			}
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'batchNameId',
		        		itemId:'batchPlcItemId',
		        		fieldLabel: getCommonTranslation('INTAKE'),
		        		store: Ext.create('Academia.store.common.BatchesByProgramId'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		allowBlank: true,
		        		typeAhead:true,
		        		disabled:true,
		        		forceSelection:true
		        	},{
		        		xtype: 'nestedJsonCombo',
		        		name: 'periodNameId',
		        		itemId:'periodIdPlcItemId',
		        		fieldLabel: getCommonTranslation('PERIOD'),
		        		store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
		        		valueField: 'id',
		        		displayField: 'value',
		        		allowBlank: true,
		        		typeAhead:true,
		        		disabled:true,
		        		forceSelection:true
		        	}]
		        },{
		        	xtype: 'fieldcontainer',
		        	layout: 'hbox',
		        	defaults: {
		        		width: 226,
		        		labelAlign: 'top'
		        	},
		        	items : [{
		        		xtype: 'datefield',
		        		name: 'startDateId',
		        		itemId:'startDatePlcItemId',
		        		allowBlank:true,
		        		//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
		        		listeners: {
		        			render: function(field) {
		        				return dateFormatRender(field);
		        			}
		        		},
		        		vtype: 'daterange',
		    			endDateField: 'endDatePlcItemId',
		    			editable:false,
		        		fieldLabel:getPlacementTranslation('START_DATE')
		        	},{
		        		xtype: 'datefield',
		        		name: 'endDateId',
		        		itemId:'endDatePlcItemId',
		        		allowBlank:true,
		        		vtype: 'daterange',
		    			startDateField: 'startDatePlcItemId',
		    			editable:false,
		    			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
		        		listeners: {
		        			render: function(field) {
		        				return dateFormatRender(field);
		        			}
		        		},
		        		fieldLabel:getPlacementTranslation('END_DATE')
		        	}] 

		        }]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtnPlcItemId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtnPlcItemId',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
