/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.program.ProgramMasterQuickFilter', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.programMasterQuickFilter',
    autoScroll: false,
    method: 'POST',
    cls:'customSearchPanel',
    standardSubmit: false,
    viewConfig: {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    items: [{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
    		xtype: 'customcombobox',
    		width:460,
    		name:'programNameOrCode',
    		store: 'program.ProgramCodeOrNameSmartSearch',
    		itemId:'programNameOrCodeQuickFiltr',
    		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
    		valueField: 'code',
    		displayField: 'valueCode',
    		queryParam:'qry',
    		minChars:3,
    		allowBlank: true,
    		typeAhead:false,
    		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    		forceSelection:true,
    		listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{code} / {value}'+ 
    				'</div>';
    			}
    		}

    	},{
    		xtype: 'customcombobox',
    		name: 'programDepartment',
    		fieldLabel: getCommonTranslation('PROGRAM_DEPARTMENT'),
    		itemId:'programDepartment',
    		store:'department.DepartmentAcademyLocationWiseStore',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:false,
 			//minChars:3,
			queryMode:'local',
			anyMatch:true
    		
    	}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		labelAlign: 'top',
    		width:226
    	},
    	items: [{
    		xtype: 'customcombobox',
    		name: 'programCategory',
    		ItemId : 'programCategory',
    		fieldLabel: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
    		store:'program.ProgramCategoryStore',
    		displayField:'value',
    		valueField:'id',
    		forceSelection:true,
    		typeAhead:false,
 			//minChars:3,
			queryMode:'local',
			anyMatch:true
    	}, {
    		xtype: 'customcombobox',
    		name: 'programMarks',
    		ItemId : 'programMarks',
    		fieldLabel: getCommonTranslation('PROGRAM_MARK_GRADE'),
    		store: 'program.ProgramMarkGradeStore',
    		displayField: 'value',
    		valueField: 'id',
    		forceSelection:true,
    	}, {
    		xtype: 'customcombobox',
    		name: ' programGroup',
    		itemId:'Program_Group',
    		fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
    		store:'program.ProgramGroupStoreForLocalSerach',
    		editable: true,
    		valueField: 'id',
    		displayField: 'value',
    		forceSelection:true,
    		typeAhead:false,
 		//	minChars:3,
			queryMode:'local',
			anyMatch:true
    	}]

    },
    {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SEARCH'),
    		itemId: 'quickSearchId',
    		buttonAlign: 'left',
    		margin:'0 0 0 0',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE
    	},{
    		xtype: 'button',
    		itemId: 'resetBtn',
    		text: getCommonTranslation('RESET'),
    		ui:'CustomBtnCancel',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]

   // }]
});