/**
 * @Author Akshay Sharma
 */
Ext.define('Academia.view.program.StudentSpecialEnrollmentFilter', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studentspecialenrollmentfilter',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'spclProgram',
			itemId: 'spclProgramId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store:'common.AssignedProgramStore',
			allowBlank: false,
			valueField: 'id',
			displayField: 'code',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'spclBatch',
			itemId:'spclBatchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			allowBlank: false,
			store: 'enquiry.AcademicBatchStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead : true,
				editable : true,
				queryMode:'local',
             	forceSelection : true,
             	anyMatch : true,
		},{
			xtype: 'customcombobox',
			name: 'spclPeriod',
			itemId:'spclPeriodId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:'program.SpecialiazedPeriodStore',
			displayField:'value',
			valueField:'id',
			allowBlank: false,
			forceSelection:true,
			typeAhead:true,
			disabled:true,
			editable:false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'specialization',
			itemId:'specializationId',
			fieldLabel : getProgramandcourseTranslation('SPECIALIZATION'),
			disabled:true,
			store: 'program.SpecializationStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true,
			editable:false

		},{
			xtype:'combo',
			name: 'status',
			itemId:'statusId',
			fieldLabel : getProgramandcourseTranslation('STATUS'),
			disabled:true,
			valueField: 'id',
			displayField: 'id',
			typeAhead:true,
			forceSelection:true,
			queryMode:'local',
			store:['Approved','Pending']
		},{
			xtype: 'customcombobox',
			name:'studentNameSearch',
			itemId: 'studentNameSearchId',
			width:450,
			fieldLabel: getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
			store:'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameStudentIdBySmartSearch',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'spclSearchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			formBind : true,
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'spclResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}]
});
