/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.courseFeeDefinition.CourseFeeDefinitionCentersGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.coursefeedefinitioncentersgrid',
    store : 'program.programDetails.programBatches.courseFeeDefinition.CourseFeeDefinitionCenterStoreGrid',
    title : getCommonTranslation('COURSE_FEE_DEFINITION'),
    border: true,
    selType :'checkboxmodel',
    viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
    itemId: 'coursefeedefinitioncentersgridId',
    dockedItems : [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [{
    		xtype : 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'program.programDetails.programBatches.courseFeeDefinition.CourseFeeDefinitionCenterStoreGrid',
    		emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
    		displayInfo : true
    	}]
    }],
    initComponent: function() {
    	var grid=this;                   
    	//grid.addExportToolBarItems(grid);
    	this.callParent(arguments);     
    },
    tbar: [/*{
    	xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },*/{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	},{
		xtype : 'button',				
		itemId : 'btnEnable',
		tooltip :getMessagingModuleTranslation('ENABLE'),
		text : getMessagingModuleTranslation('ENABLE')
	},{
		xtype: 'button',
		itemId: 'saveBtn',
		tooltip: getCommonTranslation('SAVE'),
		text: getCommonTranslation('SAVE'),
		disabled: true
	},{
    	xtype: 'button',
    	itemId: 'resetGridBtn',
    	tooltip: getExaminationTranslation('RESET'),
		text: getExaminationTranslation('RESET'),
    	disabled:true
    },{
    	xtype: 'button',
    	itemId: 'seatTypeMappingBtn',
    	tooltip: getProgramandcourseTranslation('SEAT_TYPE_MAPPING'),
		text: getProgramandcourseTranslation('SEAT_TYPE_MAPPING'),
    	disabled:true
    }],
	columns : [{
		header : getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'courseCodeName',
		flex : .2,
		sortable : true
	}, {
		header : getExaminationTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('COURSE_FEE_DEFINITION'),
		dataIndex : 'courseFeeDefinationName',
		flex : .2,
		sortable : true,
		editor:{
			xtype: 'customcombobox',
			store: Ext.create('Ext.data.Store',{
				fields:['id','value'],
				autoLoad: false,
				proxy : {
					type: 'rest',
					api : {
						read : SERVERURL.PATH_FIND_ALL_COURSE_FEE_DEFINATION_BY_COURSEID 
					},
					reader: {
						type: 'json',
					} 
				},
				listeners: {
					beforeload: function(store, operation,eOpts) {
						var selectedRecord = Ext.ComponentQuery.query('coursefeedefinitioncentersgrid')[0].getSelectionModel().getSelection();
						if(!isNullOrEmpty(selectedRecord[0])){
							store.proxy.extraParams = {
								//courseId: selectedRecord[0].get('courseId')
								courseId: selectedRecord[0].data.courseId
							}; 
						};
					}
				}
			}),
			valueField: 'id',
			displayField: 'value',
			queryParam:'query',
			minChars:3,
			typeAhead:false,
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: 'all',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			},
			listeners: {
				change: function(field){
					var grid = field.up('grid');
					var selectedRecord = grid.getPlugin().context.record;
					var oldCourseFeeDefinitionId = selectedRecord.get('oldCourseFeeDefinitionId');
					selectedRecord.set('newCourseFeeDefinitionId', field.getValue());
				}
			}
		},
		renderer:function(val,rec){
			if(!isNullOrEmpty(val)){
				try{
					return  '<a href="#">'+rec.column.getEditor().store.findRecord('id',val).get('value')+'</a>';
				}
				catch(e){
					return  '<a href="#">'+val+'</a>';
				}
			}else{
				return getCommonTranslation('CLICK_HERE_TO_SELECT');
			}
		}
	}, {
    	header: getCommonTranslation('BILLING_DATE'),
        dataIndex: 'billingDate',
        flex:.1,
        sortable: true,
        editor: {
        	xtype: 'datefield',
			name: 'billingDate',
			itemId:'billingDateItemId',
			minValue: new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },
        renderer:function(val,rec,record,rowIndex,colIndex,store,view){
        	if(!isNullOrEmpty(record.data.courseFeeDefinationId)){
            	if(isNullOrEmpty(val)){
            		rec.tdCls = 'gridInputCustomStyle'; 
            		return getCommonTranslation('CLICK_HERE_TO_SELECT');
            	}else{
            		return dateRender(val);
            	}
        	}
        	else{
        		return getCommonTranslation('CLICK_HERE_TO_SELECT');
        	}
        }
    },{
		header : getMessagingModuleTranslation('WHETHER_ENABLED'),
		dataIndex : 'whetherEnable',
		flex : .2,
		sortable : true,
		renderer : function(value, rec, record) {
			if(isNullOrEmpty(record.get('courseFeeDefinationName'))){
				return '';
			}
			else{
		    	if (value == true) {
		    		return "<font color='green'>Yes</font>";
		    	} else if(value == false){
		    		return "<font color='red'>No</font>";
		    	}
			}
	    }
	},{
		header : getProgramandcourseTranslation('SEAT_TYPE_FEE_PLAN'),
		dataIndex : 'seatTypeFeePlan',
		flex : .2,
		renderer : function(value, rec, record) {
			return '<a href="#">View</a>';
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context){
				if(editor.column.dataIndex == "billingDate"){
					if(isNullOrEmpty(editor.record.data.courseFeeDefinationId)){
						return false;
					}
					else if(isNullOrEmpty(editor.value)){
						editor.value = new Date();
						editor.column.getEditor().setMinValue(new Date());
					}
					else if(!isNullOrEmpty(editor.value)){
						if(new Date(editor.value) < new Date()){
							editor.value = new Date(editor.value);
							editor.column.getEditor().setMinValue(new Date(editor.value));
						}
						else{
							editor.value = new Date(editor.value);
							editor.column.getEditor().setMinValue(new Date());
						}
					}
				}
				else if(editor.column.dataIndex == "courseFeeDefinationName"){
					setTimeout(function(){
						var courseId = editor.record.data.courseId;
						var courseFeeDefinationId = '';
						try{
							var courseFeeDefinationId = editor.record.data.courseFeeDefinationId;
						}
						catch(e){
							//-- 
						}
						//var courseFeeDefinationId = editor.grid.getSelectionModel().getSelection()[0].get('courseFeeDefinationId');
						if(!isNullOrEmpty(courseId)){
							editor.column.getEditor().store.getProxy().extraParams.courseId = courseId;
							editor.column.getEditor().store.getProxy().extraParams.query = '';
							editor.column.getEditor().store.load({
								callback: function(){
									editor.column.getEditor().setValue(courseFeeDefinationId);
								}
							});
						}
					},100);
				}
				return true;
			}
		}
	}]
});
 