Ext.define('Academia.view.program.programDetails.programBatchDetails.relatedCourses.BatchCourseRequisites', {
	extend: 'Ext.grid.Panel',
	alias : 'widget.batchcourserequisites',
	store : 'program.programDetails.programBatches.relatedCourses.ProgramRelatedCourses',
	title : getMegaMenuTranslation('MANAGE_COURSE_REQUISITES'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		itemId:'dockedItemsItemId',
		items : [ {
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
			store : 'program.programDetails.programBatches.relatedCourses.ProgramRelatedCourses',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	tbar : [{
		xtype: 'button',
		itemId: 'btnEnableRequisites',
		tooltip: getMessagingModuleTranslation('ENABLE'),
		text : getMessagingModuleTranslation('ENABLE')
	}],
	columns : [{
		header : getCommonTranslation('COURSE_CODE_NAME'),
		dataIndex : 'courseCodeName',
		flex : .2,
		sortable : true,
		renderer:function(value, e, rec){
			if(!isNullOrEmpty(value)){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('WHETHER_ENABLED'),
		dataIndex : 'isEnable',
		flex : .2,
		sortable : true,
		renderer:function(value){
			if(isNullOrEmpty(value)){
				return  "<span style=\'color:green\'>Yes</span>";
			}else if(value){
				return "<span style=\'color:green\'>Yes</span>";
			} else {
				return "<span style=\'color:red\'>No</span>";
			}
		}
	}]

});
