Ext.define('Academia.view.program.programDetails.programBatches.CatalogueContentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.cataloguecontentgrid',
	store : 'program.programDetails.programBatches.CatalogueContentGridStore',
	title : getCommonTranslation('MANAGE_CATALOGUE_CONTENT'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'cataloguecontenttabstructure':1
		}
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		      xtype: 'custompagingtoolbar',
	          plugins:['pagesize'],
	          store : 'program.programDetails.programBatches.CatalogueContentGridStore',
	          emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
	          displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		dataIndex : 'programCodeOrName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('CONTENT_TYPE'),
		dataIndex : 'catalogueContentValue',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('FIELD_TYPE'),
		dataIndex : 'fieldType',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('CONTENT'),
		dataIndex : 'gridContent',
		flex : 1,
		sortable : true,
		 renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			 rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
			 rec.style = 'overflow: hidden;text-overflow: ellipsis;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;height: 61px;margin-bottom: 10px;'
			 return val;
		 }
	}]
});
