/**
 * @author Suraj Chouhan
 */
Ext.define('Academia.view.program.programDetails.programSubjects.ProgramSubjectsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.programsubjectsgrid',
    store: 'program.programDetails.programSubjects.ProgramSubjectsGridStore',
    title: getCommonTranslation('PROGRAM_SUBJECTS'),
    border: true,
    autoScroll: false,
    frame: false,
    cls:'emtyMsgDesign',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSaveMapProgramItemId'
	}],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('PROGRAM_ITT_SPECIALISM'),
        dataIndex: 'qualificationIttSpecialismId',
        flex: 0.7,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'programIttSpecialism',
        	itemId: 'programIttSpecialismItemId',
        	store:'program.programDetails.programSubjects.FindAllQualificationIttSpecialismComboStore',
        	allowBlank: false,
        	displayField : 'value',
        	valueField : 'id',
        	triggerAction: 'all',
        	forceSelection: true,
        	enableKeyEvents : 'true',
        	editable:false,
        	listeners :{
				select: function(combo, record){
    				var grid = Ext.ComponentQuery.query('programsubjectsgrid')[0];
    				var store = grid.getStore();
    				var flag = true;
    				store.findBy(function(rec){
						if(rec.get('qualificationIttSpecialismId') == combo.getValue()) {
							flag = false
						}
    				})

    				
    				if(flag){
//    					if(!isNullOrEmpty(selectedRecord.data.id)){
//    						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	
//
//    					}else{
//    						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
//    					}
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PROGRAM_ITT_SPECIALISM_ALREADY_SELECTED'));
    					combo.reset();
    					return false;
    				}
    			}
			},
        	listConfig: {
        		listeners: {
            		beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    },
        		}
        	} 
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
    		}
    	}
    },{
        header: getCommonTranslation('PROGRAM_SUBJECTS'),
        dataIndex: 'hesaSubjectId',
        flex: 0.7,
        sortable: true,
        editor: {
        	xtype: 'customcombobox',
        	name: 'programSubjects',
        	itemId: 'programSubjectsItemId',
        	store:'program.programDetails.programSubjects.FindAllHesaSubjectComboStore',
        	allowBlank: false,
        	displayField : 'value',
        	valueField : 'id',
        	triggerAction: 'all',
        	forceSelection: true,
        	enableKeyEvents : 'true',
        	editable:false,
        	listeners :{
				select: function(combo, record){
    				var grid = Ext.ComponentQuery.query('programsubjectsgrid')[0];
    				var store = grid.getStore();
    				var flag = true;
    				store.findBy(function(rec){
						if(rec.get('hesaSubjectId') == combo.getValue()) {
							flag = false
						}
    				})

    				
    				if(flag){
//    					if(!isNullOrEmpty(selectedRecord.data.id)){
//    						var recordToBeUpdated = grid.getStore().findRecord('id',selectedRecord.data.id);	
//
//    					}else{
//    						var recordToBeUpdated = grid.getStore().findRecord('serialNo',selectedRecord.data.serialNo);	
//    					}
    				}else{
    					showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PROGRAM_SUBJECTS_ALREADY_SELECTED'));
    					combo.reset();
    					return false;
    				}
    			}
			},
        	listConfig: {
        		listeners: {
            		beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    },
        		}
        	} 
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(value) && value !== '') {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}else{
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    				rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
    		}
    	}
    },{
        header: getCommonTranslation('PROGRAM_PROPORTION'),
        dataIndex: 'programRoleProportion',
        flex: 0.7,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'programProportion',
            itemId: 'programProportionId',
            minValue:0,
			maxLength: 3,
			width: 12,
			enforceMaxLength : true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowDecimals:false,
		    minValue: 0,
		    maxValue: 100,
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			var data=record.data;
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					return value;
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
    }, {
        header: getCommonTranslation('ADD'),
        dataIndex: 'addButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(value, meta, record) {
            if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id))
                return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.2,
        cls: 'CustomBodyBtnSettings',
        style:{'text-align':'center'},
        sortable: true,
        renderer: function(value, meta, record) {
            if (record.data.isAddDeleteRow === true || !isNullOrEmpty(record.data.id)) {
            	return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }

    }],
    plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    }
});
