/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.programCourseDashboard.CourseRosterReportSearchForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.courserosterreportsearchform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width:226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype:'hidden',
			name:'courseSectionType'
		}, {
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			store:'common.AcademicTermStore',
			typeAhead : true,
			forceSelection : true,
			hidden : false,
			width:226
		},{
			xtype: 'customcombobox',
			name: 'courseCategory',
			itemId:'courseCategory',
			fieldLabel: getProgramandcourseTranslation('COURSE_CATEGORY'),
			store:'course.CourseCategoryStore',
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
		},{
			xtype: 'customcombobox',
			name: 'courseId',
			itemId: 'courseItemId',
			store:'course.AssignedPeriodCoursesFacultyStore',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			valueField: 'courseId',
			displayField: 'courseCodeName',
			queryParam:'name',
			minChars:3,
			//width:460,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
			name:'COURSE_VARIENT_ID',
			itemId: 'courseVariantId',
			store:Ext.create('Academia.store.course.coursevariants.ParameterCourseVariantStore'),
			displayField: 'courseVariantCode',
			valueField: 'id',
			typeAhead:true,
			forceSelection:true,
			allowBlank:true,
			disabled:true
		},{
			xtype: 'customcombobox',
			name: 'STUDENT_ID',
			itemId: 'studentId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
			valueField: 'id',
			width: 226,
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			//hideTrigger:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection : true,triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'statusCombo',
			name: 'STATUS',
			itemId:'statusComboItemId',
			width:226,
			value:true,
			editable:false
		}]	
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226,
		},
		items:[]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'facultyName',
			itemId: 'facultyItemId',
			store:Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
			fieldLabel:getProgramandcourseTranslation('PRIMARY_FACULTY'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width:226,
			typeAhead : true,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name: 'alternativeFacultyName',
			itemId: 'alternativeFacultyItemId',
			store:Ext.create('Academia.store.coursetransaction.facultytopicassignment.ParameterizedFaculties'),
			fieldLabel:getProgramandcourseTranslation('ALTERNATIVE_FACULTY'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width:226,
			typeAhead : true,
			forceSelection : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:460
			},
			items:[{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('INTAKE_YEAR'),
                name: 'intakeYear',
                itemId: 'intakeYear',
                displayField: 'value',
                valueField: 'id',
                width: 226,
                typeAhead: true,
                forceSelection: true,
                minChars: 3,
                listConfig: {
                    listeners: {
                        beforeshow: function(
                            picker) {
                            picker.minWidth = picker
                                .up('combobox')
                                .getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                        return '<div class="search-item">' +
                            '{code}' +
                            '</div>';
                    }
                },
                listeners: {
                    render: function(combo) {
                        var store = Ext
                            .create('Academia.store.common.IntakeYearStore');
                        combo.bindStore(store)
                    }
                }
            }]

		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:460
			},
			items:[{
				xtype: 'customcombobox',
				name:'programId',
				itemId:'programItemId',
				store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width:226,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{code} / {value}'+
		                    '</div>';
		                }
		            }
			},{
				xtype: 'customcombobox',
				name:'batchId',
				itemId:'batchItemId',
				store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				fieldLabel:getExaminationTranslation('BATCH'),
				valueField: 'id',
				displayField: 'value',
				width:226,
				disabled:true,
				typeAhead : true,
				forceSelection : true,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			},{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId: 'periodItemId',
				disabled:true,
				store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				fieldLabel:getExaminationTranslation('PERIOD'),
				valueField: 'id',
				displayField: 'value',
				width:226,
				typeAhead : true,
				forceSelection : true,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}]

		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 460,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'sectionId',
				itemId: 'sectionItemId',
				disabled:true,
				store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
				fieldLabel:getExaminationTranslation('SECTION'),
				valueField: 'id',
				displayField: 'value',
				width:226,
				typeAhead : true,
				forceSelection : true,
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
			}
			]
		}],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			//formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
