/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.programCourseDashboard.DailyLogOrSessionReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.dailylogorsessionreportgrid',
	store: 'programCourseDashboard.DailyLogOrSessionReportGridStore',
	title: getProgramandcourseTranslation('DAILY_SESSION_REPORT'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemId :'dockedItemId',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'programCourseDashboard.DailyLogOrSessionReportGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getProgramandcourseTranslation('DATE'),
		dataIndex: 'date',
		flex:.7,
		renderer: function(value){
			return dateRender(value);
		}
	},{
		header:  getProgramandcourseTranslation('SESSION_NO'),
		dataIndex: 'sessionNo',
		flex:.8
	},{
		header:  getProgramandcourseTranslation('COURSE'),
		dataIndex: 'course',
		flex:1,
		sortable:true
	},{
		header:  getProgramandcourseTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariant',
		flex:1
	},{
		header:  getProgramandcourseTranslation('TOPIC'),
		dataIndex: 'topic',
		flex:1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
	    		return "";
	    	} else {
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
	    		return val;
				/*rec.tdAttr = 'data-qtip="' + val + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 1;-webkit-box-orient: vertical;line-height: 15px;max-height: 30px;max-width: 17ch;';
	    		return val;*/
    		}
		}
	},{
		header : getCommonTranslation('DESCRIPTION'),
		dataIndex : 'description',
		flex :1,
		sortable : true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				return	"<a href='#'>View</a>"; 
			}else{
				return "";
			}
		}
	},{
		header:  getCommonTranslation('FROM_TIME'),
		dataIndex: 'fromTimeString',
		flex:.8
		
	},{
		header:  getCommonTranslation('TO_TIME'),
		dataIndex: 'toTimeString',
		flex:.8,
		sortable:true
	},{
		header:  getProgramandcourseTranslation('TOTAL_RECORDS'),
		dataIndex: 'totalStudents',
		flex:.8
	},{
		header:  getProgramandcourseTranslation('STUDENTS_PRESENT'),
		dataIndex: 'presentStudents',
		flex:1
	},{
		header:  getProgramandcourseTranslation('FACULTY'),
		dataIndex: 'facultyName',
		flex:1
	},{
		header:  getProgramandcourseTranslation('ASSIGNMENT'),
		dataIndex: 'assignment',
		flex:1
	},{
		header:  getCommonTranslation("DOCUMENTS"),
		dataIndex: 'documents',
		sortable:true,
		renderer : function(value, meta, record) {
			if (!isNullOrEmpty(record.data.documents)) {
				if (record.data.documents.length > 1) {
					return '<a href=#>' + record.data.documents.length + '</a>';
				} else if (record.data.documents.length == 1) {
					return '<a href=#>' + record.data.documents[0].value + '</a>';
				}
			}
		}
	}]
});
