/**
 * @author Utsav Chandvaniya
 */
Ext.define('Academia.view.programCourseDashboard.DelayedCourseSearch', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.delayedcoursesearch',
	autoScroll: false,
	frame: false,
	cls:'panelNoSpace',
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{	
			xtype:'panel',
			width: '100%',
			cls:'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'selectionTypeId',				
				columns: 2,
				vertical: false,				
				items: [
				        { boxLabel: getProgramandcourseTranslation('PROGRAM_BATCH_SECTION'), name: 'selectionType', inputValue: 'PROGRAM_BATCH_SECTION',checked:true},
				        { boxLabel: getProgramandcourseTranslation('COURSE_SECTION'), name: 'selectionType', inputValue: 'COURSE_SECTION'}
				        ]
			}]			
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults :{
				labelAlign:'top',
				width:226
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'PROGRAM',
				name : 'programId',
				itemId : 'programId',      	   
				store:'common.ClassTeacherProgramStore',
				displayField : 'valueCode',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false,
				queryParam:'name',
				minChars:3,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},
			{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),		

				name : 'batchId',
				itemId : 'batchId',
				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				name : 'academicTerm',
				itemId : 'academicTermId',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				editable:false,
				hidden : true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey: 'COURSE',
				name : 'courseIdCBS',	
				itemId : 'courseIdCBS',
				store : Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
				displayField : 'courseCodeName',
				valueField : 'courseId',
				typeAhead : true,
				forceSelection : true,
				hidden : true,
				queryParam:'name',
	  			typeAhead:true,
	  			minChars:3,
	  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width+50;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
	  			}
			},{
				xtype: 'customcombobox',
				fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
				name:'courseVariant',
				itemId: 'courseVariantId',
				store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				displayField: 'courseVariantCode',
				valueField: 'id',
				typeAhead:true,
				forceSelection:true,
				disabled:true,
				editable:false,
				hidden : true
			},
			{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),

				name : 'periodId',
				itemId : 'periodId',
				store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				hidden : false
			}]},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults :{
					labelAlign:'top',
					width:226
				},
				items: [{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
//					translationKey: 'COURSE',
					name : 'courseIdPBS',
					itemId : 'courseIdPBS',
					store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					hidden : false,
					minChars:3,
					queryParam:'name',
		  			typeAhead:true,
		  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width+50;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}' +
							'</div>';
						}
		  			}
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					name : 'programSectionId',
					itemId : 'programSectionId',
					store : 'coursetransaction.sectionmanagement.SectionsStore',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					hidden : false
				},{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
					name: 'facultyCodeItem',
					itemId:'facultyCodeItemId',
					store:'common.ActiveUserStore',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					typeAhead:false,
					hideTrigger:true,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
						}
					}
				}]
			},{
				xtype: 'fieldcontainer',
				width: '100%',

				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'btnSearch',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE               
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'btnReset',
					// buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}]	
			}]
	},{
		xtype:'panel',
		style:{margin:'-3px 10px 25px 10px !important'}, 
		items:[{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('DELAYED_COURSE'),
			width: '100%',
			itemId:'delayedCourseSearchGrIdPBS',
			hidden:false,
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		},{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('DELAYED_COURSE'),
			width: '100%',
			itemId:'delayedCourseSearchGrIdCBS',
			hidden:true,
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		}]
	}]

});