/**
 * @author Raghavendra Soni
 */
var stCourseSectionReportGridStore = Ext.create('Academia.store.coursetransaction.sectionmanagement.CourseSectionReportGridStore');
Ext.define('Academia.view.programCourseDashboard.StudentCourseSectionReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.studentcoursesectionreportgrid',
	store : stCourseSectionReportGridStore,
	title: getCommonTranslation('LIST_OF_COURSE_SECTION'),
	border: true,
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	flex:1,
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : stCourseSectionReportGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header : getCourseTxCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('COURSE_CODE'),
		dataIndex : 'courseCode',
		flex:1
	},{
		header : getCommonTranslation('CAMPUS'),
		dataIndex : 'academyLocationName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('SECTION_NAME'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('ALTERNATE_NAME'),
		dataIndex : 'alternateName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('RULE'),
		dataIndex : 'sectionRule',
		flex:1,
		hidden:true
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariant',
		flex:1
	},{
		header : getCourseTxCommonTranslation('HOME_ROOM'),
		dataIndex : 'homeRoom',
		flex:1
	},{
		header : getCommonTranslation('CALENDAR'),
		dataIndex : 'calendarName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('CAPACITY'),
		dataIndex : 'capacity',
		flex:1
	},{
		header : getProgramandcourseTranslation('ENROLLED_STUDENTS'),
		dataIndex : 'enrolled',
		flex:1,
		renderer:function(value){
			if(value!=null && value >0){
			  return '<a  href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCommonTranslation('EXAM_DATE'),
		dataIndex : 'examDate',
		flex:1
	}, {
		header : getCommonTranslation('EXAM_TIME'),
		dataIndex : 'examTime',
		flex:1
	}]
});
