/**
 * 
 */
Ext.define('Academia.view.registrationsetup.RegistrationSetupProfileUpdateGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.registrationsetupprofileupdategrid',
	store: 'registrationsetup.RegistrationSetupProfileUpdateGridStore',
	border: true,
	autoScroll: false,
	cls:'clsAssigneeApproverGrid',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	style:{
		marginLeft:'0px'
	},
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : true
	},
	initComponent: function() {
		var grid=this;                   
		//grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header: getCommonTranslation("LINK_NAME"),
		dataIndex: 'linkName',
		flex:1,
		sortable:false

	},{
		header:getCommonTranslation('MODULE_SEQUENCE'),
		flex:1,
		sortable:false,
		dataIndex : 'sequenceNo',
		editor: {
        	xtype: 'numberfield',
        	name: 'sequenceNo',
        	minValue:1,
        	maxValue:20,
        	maxLength: 2,
        	width: 12,
        	//enforceMaxLength : true,
        	keyNavEnabled: false,
        	mouseWheelEnabled: false,
        	allowDecimals:false,
        	itemId: 'sequenceNoItemId'
        },
        renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
        	if(record.data.moduleName != 'Program Details'){
        		if(!isNullOrEmpty(value) && value !== '') {
        			try{
        				rec.tdCls = 'gridInputCustomStyleForSqeuence';
        				return value;
        			}
        			catch(e){
        				return null;
        			}
        		}
        		else {
        			rec.tdCls = 'gridInputCustomStyleForSqeuence';
        			return getExaminationTranslation('CLICK_TO_ENTER');
        		}
        	}
        }			
	}],
	plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
           beforeedit: function(editor, e, context) {
            	if(e.field == "sequenceNo" && e.value === 1){
            		return false;
            	}
            },
            edit: function(editor, e, context) {
            	if(e.value == 1){
            		var rowData = e.record.data;
                	var grid = e.grid;
                    var models = grid.getStore().getRange();
                    models[e.rowIdx].set(e.field,e.originalValue);
            	}
            	else{
            		var grid = e.grid;
            		var store = grid.getStore();
            		var storeItems = store.data.items;
            		var isEdit = true;
            		var selId = e.record.data.id;
            		storeItems.forEach(function(obj){
						
            			if(e.value == obj.data.sequenceNo){
            				if(selId != obj.data.id){
            					isEdit = false;
            				}
            			}
            			
					});
            		
            		if(!isEdit){
            			var models = grid.getStore().getRange();
                        models[e.rowIdx].set(e.field,e.originalValue);
            		}
            	}
            },
            canceledit: function(editor, e, context) {
            	var grid = e.grid;
            	grid.up('form').getForm().checkValidity();
            }
        }
    }]
});