/**
 * This is used for simple line chart chart report
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.common.SimpleLineChartReport', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.simplelinechartreport',
    animate: true,
    shadow: true,
    initComponent: function() {
        var this$ = this;
        var numberField = !isNullOrEmpty(this.yAxesCategoryField)?this.yAxesCategoryField:'number';
        var categoryField = !isNullOrEmpty(this.xAxesNumericField)?this.xAxesNumericField:'category';
        var numericTitle = !isNullOrEmpty(this.yAxesCategoryTitle)?this.yAxesCategoryTitle: getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = !isNullOrEmpty(this.xAxesNumericTitle)?this.xAxesNumericTitle:getCommonTranslation('CATEGOTY_TITLE');
        var xAxesFieldSpace = !isNullOrEmpty(this.xAxesFieldSpace)?this.xAxesFieldSpace : 10;
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['number', 'category'],
        		data: [{
        			number :0,
        			category : 'Category'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
            axes: [{
                type: 'Numeric',
                minimum: 0,
                position: 'left',
                fields: [numberField],
                title: numericTitle,
                grid: true,
                label: {
                    renderer: Ext.util.Format.numberRenderer('0,0'),
                    font: '10px Arial'
                }
            }, {

                type: 'Category',
                position: 'bottom',
                fields: [categoryField],
                title: categoryTitle,
                label: {
                    font: '11px Arial',
                    	rotate: {
                            degrees: 50
                        }
                }
            }],
            series: [{
                type: 'line',
                axis: 'left',
                xField: categoryField,
                yField: numberField,
                listeners: {
                  itemmouseup: function(item) {
                	  console.log('item',item);
                	  var systemUsageController=  Academia.app.getController('Academia.controller.systemusage.SystemUsageController');
                	  systemUsageController.dailyUsageRecordGrid(item);
                      //Ext.example.msg(item.value[1] + ':' + item.value[0]);
                  }  
                },
                tips: {
                    trackMouse: true,
                    width: 80,
                    height: 40,
                    renderer: function(storeItem, item) {
                      var displayNumberField = Ext.util.Format.number(storeItem.get(numberField), '0.00');
                      var tipTitle = storeItem.get(categoryField) + ': ' + displayNumberField;
                  	  var length = (tipTitle.length)* 10;
                  	  this.setWidth(length);
                  	  this.setTitle(tipTitle);
                    }
                },
                style: {
                    fill: '#38B8BF',
                    stroke: '#38B8BF',
                    'stroke-width': 3
                },
                markerConfig: {
                    type: 'circle',
                    size: 4,
                    radius: 4,
                    'stroke-width': 0,
                    fill: '#38B8BF',
                    stroke: '#38B8BF'
                }
            }],
            listeners: {
                refresh: function(chart) {
                	var count = chart.getStore().getCount();
                	if(count>0){
                		var chartWidth = count * xAxesFieldSpace; 
                		chart.setWidth(chartWidth);
                		chart.doComponentLayout();
                	}
                }
            }
        });

        this$.callParent(arguments);
    }
});