/**
 * This view is used for complaint service level 
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.complaints.ComplaintServiceLevelGraphView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.complaintservicelevelgraphview',
    frame: true,
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'complaintservicelevelgraphsearch',
        itemId: 'complaintServiceLevelGraphSearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'groupedbarchart',
            itemId: 'complaintServiceLevelChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            store: 'Academia.store.reports.servicerequest.ServiceLevelGraphStore',
            xAxesCategoryField: 'MONTH',
            xAxesCategoryTitle: getServiceRequestTranslation('MONTHS'),
            yAxesNumericField: 'count',
            yAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            groupField: ['BEYOND_LIMIT', 'BEYOND', 'BEFORE', 'ONDATE']
        }]
    }]
});