/**
 * This view is used for student count of request
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.complaints.ComplaintsHistoryGraphView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.complaintshistorygraphview',
    title: getServiceRequestTranslation('COMPLAINTS_HISTORY_GRAPH'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
        xtype: 'complaintshistorysearchform',
        itemId: 'complaintsHistorySearchForm'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'columnchartreport',
            itemId: 'complaintHistoryChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            columnWidth: 50,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.CountOfRequestStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_COMPLAINTS'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('MONTHS')
        }]
    }]
});