/**
 * This view is used for the Follow Up Scheduled report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.complaints.FollowUpScheduledComplaintSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.followupscheduledcomplaintsearchform',
    frame: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'complaintTypeId',
            itemId: 'complaintTypeField',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
            displayField: 'value',
            valueField: 'id',
            autoload: false,
            editable: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintTypes');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'livesearchcombo',
            itemId: 'assigneeCombo',
            width: 226,
            fieldLabel: getServiceRequestTranslation('ASSIGN_TO'),
            name: 'assignTo',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            itemId: 'startDate',
            name: 'startDate',
            fieldLabel: getServiceRequestTranslation('FOLLOW_UP_START_DATE'),
            vtype: 'daterange',
            endDateField: 'endDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId : 'endDate',
            vtype: 'daterange',
            fieldLabel: getServiceRequestTranslation('FOLLOW_UP_END_DATE'),
            startDateField: 'startDate',
            maxValue : new Date(),
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'resourceGroup',
            itemId: 'faciltyTypeField',
            fieldLabel: getServiceRequestTranslation('FACILITY_TYPE'),
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            autoload: false,
            editable: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceGroupStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'resourceTypeId',
            itemId: 'physicalTypeField',
            fieldLabel: getServiceRequestTranslation('PHYSICAL_FACILITY_TYPE'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            width: 226,
            editable: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceTypeStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'resourceId',
            itemId: 'facilityCodeField',
            fieldLabel: getServiceRequestTranslation('FACILITY_CODE'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            editable: false,
            width: 226,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.InternalResourceStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]

});