/**
 *  This grid is used for followup student/faculty request
 *  @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.servicerequest.FollowupRequestReportGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport', 
	alias: 'widget.followuprequestreportgrid',
	title: getServiceRequestTranslation('FOLLOW_UP_SCHEDULED'),
	border: true,
	border: true,
	overflowX:'auto',
	maxHeight:700,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [{
		header: getServiceRequestTranslation('REQUEST_ID'),
		dataIndex: 'requestId',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return '<a href="#">'+ value +'</a>';
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_CATEGORY'),
		dataIndex: 'requestType',
		sortable: true,
		flex: .2,
		renderer: function(value){
			if(value!=null){
				return	getServiceRequestTranslation(value);
			}
			else
				return value;
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_TYPE'),
		dataIndex: 'subRequestType',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('REQUESTER_NAME'),
		dataIndex: 'requesterName',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
		dataIndex: 'requestAssignedTo',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('NEXT_FOLLOW_UP_DATE'),
		dataIndex: 'followupPlanDate',
		sortable: true,
		flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}

	}/*, {
        header: getServiceRequestTranslation('LAST_FOLLOW_UP_DATE'),
        dataIndex: 'lastFollowUpDate',
        sortable: true,
        flex: .2
    }*/],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.reports.servicerequest.FollowupRequestStore');
    }
});