/**
 * This view is used for student count of request
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.student.StudentCountOfRequestView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.studentcountofrequestview',
    title: getServiceRequestTranslation('COUNT_OF_REQUEST'),
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'requestclosureratesearchform',
        itemId: 'studentCountOfRequestSearch',
        listeners: {
            render: function(form) {
                var assigneeCombo = form.down('#assigneeCombo');
                assigneeCombo.setVisible(true);
            }
        }
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'columnchartreport',
            itemId: 'studentCountOfRequestChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            columnWidth: 50,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.CountOfRequestStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('MONTHS')
        }]
    }]
});