/**
 * This view is used for student request closure rate 
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.student.StudentRequestClosureRateView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.studentrequestclosurerateview',
    title: getServiceRequestTranslation('REQUEST_CLOSURE_RATE'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
        xtype: 'requestclosureratesearchform',
        itemId: 'studentRequestClosureRateSearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'columnchartreport',
            itemId: 'studentRequestClosureRateChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            columnWidth: 50,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.RequestClosureRateStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('CLOSED_IN_DAYS')
        }]
    }]
});