/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.reports.survey.ActiveSurveyReport', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.activesurveyreport',
	store : 'reports.survey.ActiveSurveyStore',
	title: getCommonTranslation('ACTIVE_SURVEY'),
	cls:'centerAlignTitle',
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},  
	/*tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCourseTxCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],*/
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'reports.survey.ActiveSurveyStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header : getCommonTranslation('SURVEY_TITLE'),
		dataIndex : 'surveyTitle',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_COUNT'),
		dataIndex : 'userCount',
		flex:1
	},{
		header : getCommonTranslation('FACULTY_COUNT'),
		dataIndex : 'facultyCount',
		flex:1
	},{
		header : getCommonTranslation('APPLICANT_COUNT'),
		dataIndex : 'applicantCount',
		flex:1
	},{
		header : getCommonTranslation('ENQUIRY_COUNT'),
		dataIndex : 'enquiryCount',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_DISTRIBUTION_COUNT'),
		dataIndex : 'toatalDistributionCount',
		flex:1
	},{
		header : getCommonTranslation('COMPLETED_RESPONSES'),
		dataIndex : 'completedResponses',
		flex:1
	},{
		header : getCommonTranslation('INCOMPLETED_RESPONSES'),
		dataIndex : 'incompleteResponses',
		flex:1
	},{
		header : getCommonTranslation('FULL_RESPONSES'),
		dataIndex : 'fullResponses',
		flex:1
	},{
		header : getCommonTranslation('PARTICIPANT_LIST'),
		dataIndex : 'linkToSeeParticipantList',
		flex:1,
		renderer : function(value, metaData, record, row, col, store, gridView){
			return  '<a href="#">'+"View"+'</a>';
		}
	}]
});
