/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.reports.survey.ParticipantInfoWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.participantinfowindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	//height: 'auto',
	height: '50%',
	width: '70%',
	frame: true,
	title:getCommonTranslation('PARTICIPANT_INFO'),
	items: [{
		xtype: 'grid',
		store : 'reports.survey.ParticipantStore',
		autoScroll: true,
		itemId : 'participantGrid',
		border: true,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'reports.survey.ParticipantStore',
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getCommonTranslation('PARTICIPANT_NAME'),
			dataIndex : 'participantName',
			flex : 1
		},{
			header : getCommonTranslation('PARTICIPANT_EMAIL'),
			dataIndex : 'participantEmail',
			flex : 1
		},{
			header : getCommonTranslation('SURVEY_SHARE_DATE'),
			dataIndex : 'surveySharedDate',
			flex : 1,
			renderer: function(date) {
				if(!isNullOrEmpty(date)){
					return dateRender(date);
				}
			}
		},{
			header : getCommonTranslation('PARTICIPANT_TYPE'),
			dataIndex : 'userType',
			flex : 1,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return getCommonTranslation(value);
				}
			}
		}] 	

	}]
});
