Ext.define('Academia.view.reports.systemutilization.loginFrequency.LoginFrequencyGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.loginfrequencygrid',
	title : getCommonTranslation('USER_LOGIN_FREQUENCY_SUMMARY'),
	border : true,
	
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	
	// NOTE : if you update columns, please update code in LoginFrequencyController.js -> loadActiveGrid()
	columns : [{
		header : getCommonTranslation('USER_CODE'),
		dataIndex: 'code',
		flex: 1
	}, { 
		header : getPersonModuleTranslation('PRINT_NAME'),
		dataIndex : 'printName',
		flex: 1
	}, { 
		header : getCommonTranslation('LOGIN_PERIOD'),
		dataIndex : 'userLoginPeriod',
		hidden : true,
		flex: 1
	}, {
		header : getCommonTranslation('LOGIN_COUNT'),
		name:'count',
		dataIndex : 'count',
		flex: 1,
		renderer: function(obj, metaData, record, row, col, store, gridView) {
			var grid = gridView.up('grid');
			console.log('grid',grid);
			if(grid.itemId == 'loginfrequencygrid'){
//				grid.setTitle("Test");
				return "<a href='#'>"+obj+"</a>"; 
			}else{
				return obj;
			}
		}
	}, {
		header : getAdmissionTranslation('TOTAL_TIME_SPEND'),
		dataIndex : 'timeSpent',
		flex: 1,
		renderer: function(obj, metaData, record, row, col, store, gridView) {
			if(obj){
				return minuteToTimeRender(obj);
			}
		}
	//renderer: minuteToTimeRender
	}],
	
	initComponent: function() {
		var this$ = this;
		this$.addExportToolBarItems(this$);
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.reports.systemutilization.loginFrequency.LoginFrequencyGridStore');
	}
});