/**
 * @author raghavendra soni
 */
Ext.define('Academia.view.salesandadmissionreport.SalesAndAdmissionReportFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.salesandadmissionreportfilter',
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    plugins:"formlabelrequired",
    items: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			width: 960,
			height:58,
			name: 'multiselectAcademy',
			itemId: 'multiselectAcademyId',
			allowBlank : false,
			fieldLabel : getCommonTranslation('ACADEMIES'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			autoloadStore: false,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
        	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.common.AcademyByUserStore');
        			combo.bindStore(store)
        		}
        	}
		}]
		},{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	xtype : 'customcombobox',
            	fieldLabel : getCommonTranslation('INTAKE_YEAR'),
            	name : 'intakeYear',
            	itemId : 'intakeYear',
            	displayField:'value',
            	valueField:'id',
            	allowBlank: false,
            	typeAhead:true,
            	forceSelection:true,
            	minChars:3,
    			matchFieldWidth:true,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code}'  +
            			'</div>';
            		}
            	},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.IntakeYearStore');
            			combo.bindStore(store)
            		}
            	}
            },{
    			xtype : 'multiselectcombofield',
    			cls:'commonAutoHeightMultiselectField',
    			fieldLabel: getCommonTranslation('SEAT_TYPE'),
    			name: 'seatType',
    			itemId:'seatType',
    			displayField: 'value',
    			valueField: 'id',
    			typeAhead : true,
    			forceSelection : true,
    			editable: false,
    			disableKeyFilter: false,
    			store:Ext.create('Academia.store.common.AllSeatTypeListStore'),
    			listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    			return '<div class="search-item">' +
    						'{code}'  + '{value}' +
    				        '</div>';
    			}
    			}
    		}]
    },{
	    xtype: 'fieldcontainer',
        width:'100%',
        cls:'windowBtnPos',
        items: [{
            xtype: 'button',
            itemId:'searchBtn',
            text: getCommonTranslation('SEARCH'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId:'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
}]
});
