/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.scholarship.managescholarship.ScholarshipHistoryGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.scholarshipHistoryGrid',
	store: 'scholarships.ScholarshipsHistoryStore',
	title:getCommonTranslation('SCHOLARSHIP_HISTORY'),
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [{
		header:  getCommonTranslation("SCHOLARSHIP_APPLICATION_ID"),
		dataIndex:'scholarshipApplicationID',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			if(record.get("scholarshipCategory") == 'DEPARTMENTAL') {
				return 'Req'+ value;
			}
			return value;
		}
	},{
		header:  getCommonTranslation("SCHOLARSHIP_ID"),
		dataIndex:'scholarshipCode',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SCHOLARSHIP_NAME"),
		dataIndex:'scholarshipName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("SCHOLARSHIP_CATEGORY"),
		dataIndex:'scholarshipCategory',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			switch(value) {
			  case 'NOMINATION':
				  return getCommonTranslation('NOMINATION');
				  break;
			  case 'NSFAS': 
				  return 'NSFAS';
				  break;
			  case 'NRF': 
				  return 'NRF';
				  break;
			  case 'DEPARTMENTAL': 
				  return 'Departmental';
				  break;
				 
			}
}	
	},{
		header:  getCommonTranslation('ACCOUNTING_YEAR'),
		dataIndex:'accountingYear',
		flex:.1,
		sortable:true
	},
	{
		header:  getCommonTranslation("GRADUATE_LEVEL"),
		dataIndex:'graduateLevel',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			switch(value) {
			  case 'UNDERGRADUATE':
				  return getCommonTranslation('UNDERGRADUATE');
				  break;
			  case 'POST_GRADUATE': 
				  return getCommonTranslation('POST_GRADUATE');
				  break;
				 
			}
}
	},{
		header:  getHostelTranslation('AMOUNT'),
		dataIndex:'amount',
		flex:.1
	},{
		header:  getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex:.1,
		renderer:function(value,meta,record){
			if(!Ext.isEmpty(record.get("scholarshipAwardeeStatus"))){
				switch(record.get("scholarshipAwardeeStatus")) {
				  case 'AWARD_ACTIVATION_PENDING':
					  return getCommonTranslation('AWARD_ACTIVATION_PENDING');
					  break;
				  case 'SCHOLARSHIP_ACTIVATED': 
					  return getCommonTranslation("SCHOLARSHIP_ACTIVATED");
					  break;
				  case 'AWARD_ACTIVATION_REJECTED': 
					  return getCommonTranslation("AWARD_ACTIVATION_REJECTED");
					  break;
				}
			}else if(record.get("scholarshipCategory") == "DEPARTMENTAL" && !Ext.isEmpty(record.get("raiseRequestStatus"))){
				switch(record.get("raiseRequestStatus")) {
				  case 'AWARDED': 
					  return getCommonTranslation("AWARDED");
					  break;
				  case 'DECLINED': 
					  return getCommonTranslation("DECLINED");
					  break;
				  case 'REJECTED': 
					  return getCommonTranslation("REJECTED");
					  break;
				 case 'REJECTED_BO': 
					  return getCommonTranslation("REJECTED");
					  break;
				  case 'ASSIGNED':
						return getCommonTranslation("ASSIGNED_TO_LINE_MANAGER");
						break;
					case 'APPROVED':
					case 'Approved': 
						return getCommonTranslation("APPROVED_BY_LINE_MANAGER");
						break;
					case 'REASSIGNED':
						return getCommonTranslation("RE_ASSIGNED_TO_ADMIN");
						break;
					case 'REJECTED':
					case 'REJECTED_BO':
						return getCommonTranslation("REJECTED");
						break;
					case 'CLOSED':
						return getCommonTranslation("AWARD_ACTIVATION_PENDING");
						break;
					case 'RESUBMITTED':
						return 'Re-Submitted';
						break;
				}
			}else if(!Ext.isEmpty(record.get("status"))){
				switch(record.get("status")) {
				  case 'NOMINATED':
					  return getCommonTranslation("NOMINATED");
					  break;
				  case 'ACCEPTANCE_PENDING': 
					  return getCommonTranslation("ACCEPTANCE_PENDING");
					  break;
				  case 'REJECTED':
					  return getCommonTranslation("REJECTED");
				    break;
				  case 'DECLINED':
					  return getCommonTranslation("DECLINED");
				    break;
				  case 'ACCEPTED':
					  return getCommonTranslation("ACCEPTED");
				    break;
				  case 'AWARDED':
					  return getCommonTranslation("AWARDED");
				    break;
				  case 'DOCUMENT_RE_SUBMISSION':
					  return getCommonTranslation("DOCUMENT_RE_SUBMISSION");
					    break;
				  case 'AWARD_ACTIVATION_PENDING':
					  return getCommonTranslation("AWARD_ACTIVATION_PENDING");
					    break;
				  case 'VERIFICATION_IN_PROGRESS':
					  return getCommonTranslation("VERIFICATION_IN_PROGRESS");
					  break;
				  case 'SCHOLARSHIP_ACTIVATED':
					  return getCommonTranslation("SCHOLARSHIP_ACTIVATED");
					  break;
				  case 'AWARD_ACTIVATION_REJECTED':
					  return getCommonTranslation("AWARD_ACTIVATION_REJECTED");
					  break;
				  default:
					  break;
				}
			}
				
	}
	},{
		header:  getAdmissionTranslation('REJECTION_REASONS'),
		dataIndex:'rejectionReason',
		flex:.1
	},{
		header:  getCommonTranslation('DATE'),
		dataIndex:'updateDate',
		flex:.1,
		renderer:function(val){
			if(val){
				return dateRender(val);
			}
			return "";
		}
	},{
		header:  getCommonTranslation('ACTIONED_BY'),
		dataIndex:'appliedBy',
		flex:.1,
		renderer:function(value,meta,record){
			if(value !=="APPLICANT PORTAL"){
				return value;
			}
			return record.get('applicantName');
		}
	}]
});