/**
 * sumit sharma 
 */
Ext.define('Academia.view.scholarship.poetmaster.PoetMasterFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.poetmasterfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('PROJECT_NUMBER'),
                itemId: 'projectNumber',
                name: 'projectNumber',
                enableKeyEvents: true,
                vtype: 'NospaceAsInput',
                store:'poet.PoetProjectNumberStore',
    			width:226,
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'projectNumber',
    			minChars:3,
    			typeAhead:false,
    			//disabled:true,
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
            }, {
				xtype: 'customcombobox',
				name:'feeHeadName',
				itemId:'feeHeadName', 
				store:'poet.PoetFeeHeadStore',
				fieldLabel: getCommonTranslation('FEE_HEAD'),
				valueField: 'id',
				displayField: 'feeHeadName',
				typeAhead:true,
				//value:'ALL',
				forceSelection:true,
				

			}]
    },/* {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'taskStatus',
            itemId: 'taskStatusItemId',
            fieldLabel: getServiceRequestTranslation('EMM_TASK_STATUS'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
           // store: 'eventmeetingminutes.EventMeetingMinutesStatusStore',
        }]
    }, */{
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnTmmytasksfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetTmmytasksfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});
