/**
 * File for the fields having the add awardee functionality from the scholarship listing screen.
 * @author akshay.kalbhor
 */
Ext.define('Academia.view.scholarship.scholarshiplisting.AddAwardee', {
    extend: 'Ext.window.Window',
    alias: 'widget.addawardee',
    modal: true,
    resizable: false,
    autoScroll: true,
    title: getCommonTranslation('AWARDEE_DETAILS'),
    items: [{
        xtype: 'form',
        itemId: 'addAwardeeForm',
        plugins: "formlabelrequired",
        items: [{
            xtype: 'hidden',
            name: 'id',
            itemId: 'awardee_hidden_id'
        }, {
            xtype: 'hidden',
            name: 'version',
            itemId: 'version'
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('SCHOLARSHIP_NAME'),
                store: 'scholarships.AddAwardeeScholarshipComboStore',
                name: 'scholarshipId',
                itemId: 'scholarshipCmp',
                editable: false,
                valueField: 'id',
                displayField: 'scholarshipName',
                //emptyText: getCommonTranslation('SELECT_SCHOLARSHIP_NAME'), 
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false,
                listeners: function() {
                    this.up('panel[xtype=addawardee]').down('datefield#validFrom').reset();
                    this.up('panel[xtype=addawardee]').down('datefield#validUpto').reset();
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'livesearchcombo',
                labelAlign: 'top',
                width: 226,
                queryParam: 'name',
                allowBlank: false,
                name: 'studentId',
                itemId: 'studentCmp',
                disabled: true,
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                fieldLabel: getCommonTranslation('STUDENT_CODE_NAME'),
                displayField: 'value',
                valueField: 'id',
                displayTpl: new Ext.XTemplate('<tpl for="."between=" ">', '{[typeof values === "string" ? values : values["value"]]}' + '</tpl>'),
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.sponsorship.Students');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('PROGRAM'),
                store: 'scholarships.AddAwardeeProgramComboStore',
                name: 'programId',
                itemId: 'programId',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                allowBlank: false
            }, {
                xtype: 'hidden',
                name: 'admissionId',
                itemId: 'hidden_admissionId'
           /* }, {
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('COURSE'),
                store: 'scholarships.AddAwardeeCourseComboStore',
                name: 'courseVariantId',
                itemId: 'courseVariantId',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                queryMode: 'local',
                triggerAction: 'all',
                forceSelection: true,
                hidden: true*/
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'datefield',
                name: 'appliedOn',
                itemId: 'appliedOn',
                fieldLabel: getCommonTranslation('APPLIED_DATE'),
                //emptyText: getCommonTranslation('SELECT_APPLIED_DATE'),
                editable: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                allowBlank: false
            }, {
                xtype: 'datefield',
                name: 'awardedOn',
                itemId: 'awardedOn',
                fieldLabel: getCommonTranslation('AWARD_DATE'),
                //emptyText: getCommonTranslation('SELECT_AWARD_DATE'),
                editable: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'datefield',
                name: 'validFrom',
                itemId: 'validFrom',
                fieldLabel: getCommonTranslation('VALID_FROM'),
                //emptyText: getCommonTranslation('SELECT_FROM_DATE'),
                editable: false,
//                submitFormat: CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                allowBlank: false
            }, {
                xtype: 'datefield',
                name: 'validUpto',
                itemId: 'validUpto',
                fieldLabel: getCommonTranslation('VALID_TILL'),
                //emptyText: getCommonTranslation('SELECT_TILL_DATE'),
                editable: false,
//                submitFormat: CONSTANTS.DATE_FORMAT,
                listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                /*
                * Commented the combo for resolution of ISSUE#37524 
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('CURRENCY'),
                name: 'currencyId',
                itemId: 'currencyCmb',
                store: 'scholarships.Currencys',
                queryMode: 'local',
                displayField: 'value',
                valueField: 'id',
                readOnly: true,
                //disabled: true,
                queryMode: 'local'
            }, {*/
                xtype: 'numberfield',
                name: 'scholarshipAmount',
                itemId: 'scholarshipAmount',
                fieldLabel: getCommonTranslation('SCHOLARSHIP_AMOUNT'),
                minValue: 0,
				maxLength:10,
                value: 0
            }]
        },
        {
			xtype:'textareafield',
			labelAlign:'top',
			name:'remarks',
			width:450,
			fieldLabel:getCommonTranslation('REMARKS'),
			itemId:'remarks',
			maxLength:250
		},
        {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'addAwardeeBtn',
                action: 'save',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'cancel',
                ui: 'CustomBtnCancel',
                itemId: 'cancelAwardeeBtn',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});