/**
 *  @author Niklesh T
 */

Ext.define('Academia.view.scholarship.scholarshipmaster.AddScholarshipAlGridWithProgramGroup', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.addScholarshipAlGridWithProgramGroup',
	title : getCommonTranslation('PROGRAM_GROUP'),
	store: 'scholarships.AddScholarshipAlMappingWithProgramGroupStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
//	autoScroll: true,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	 /*dockedItems: [{
	        xtype: 'toolbar',
	        dock: 'bottom',
	        items: [{
	            xtype: 'custompagingtoolbar',
	            plugins: ['pagesize'],
	            store: 'scholarships.AddScholarshipAlMappingWithProgramStore',
	            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	            displayInfo: true
	        }]
	    }],*/
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getCommonTranslation('NEXT'),
		tooltip: getCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programGroupsearchcombo',
		itemId:'programGroupsearchcomboId',
		store: 'scholarships.AddScholarshipAlMappingWithProgramGroupStore',
		valueField: 'longValue',
		displayField: 'value',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'qry',
		queryMode: 'remote',
		width:226,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.width = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'secondValue',
		flex : 1	 
	},{
		header : getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'value',
		flex : 1	 
	}
	]
});
