Ext.define('Academia.view.scholarship.scholarshipmaster.ScholarshipRequestListSerachForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.scholarshipRequestListSerachForm',
    autoScroll: true,
    frame: false,
    layout: 'vbox',
    cls: 'customSearchPanel',
    plugins : "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'scholarshipList',
        //   method : 'POST',
        items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel:getCommonTranslation('REQUEST_ID'),
                itemId: 'requestId',
                name: 'requestId',
                store:'scholarships.RequestTypeStore',
    			width:226,
    			valueField: 'id',
    			displayField: 'value',
    			queryParam:'qry',
    			minChars:3,
    			typeAhead:false,
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
            },{
            	xtype: 'customcombobox',
            	fieldLabel: getCommonTranslation('REQUESTER_TYPE'),
            	name: 'requesterType',
            	itemId: 'requesterType',
            	editable: false,
            	store: Ext.create('Ext.data.Store', {
            		fields: ['name', 'value'],
            		data : [{
            			name:"Student", value:"Student"
            		},{
            			name:"Applicant", value:"Applicant"
            		}]
            	}),
            	valueField: 'value',
            	displayField: 'name',
            	queryMode: 'local',
            	selectOnFocus: true,
            	value: 'Student',
            	forceSelection: false
            },{
            	xtype: 'customcombobox',
            	fieldLabel: getCommonTranslation('STUDENT_STATUS'),
            	name: 'stdStatus',
            	itemId: 'stdStatus',
            	editable: false,
            	allowBlank:false,
            	store: Ext.create('Ext.data.Store', {
            		fields: ['name', 'value'],
            		data : [{
            			name:getCommonTranslation('SCHL_ACTIVE'), value:"ACTIVE"
            		},{
            			name:getCommonTranslation('SCHL_INACTIVE'), value:"INACTIVE"
            		},{
            			name:getCommonTranslation('SCHL_ALL'),value:'ALL'
            		}]
            	}),
            	valueField: 'value',
            	displayField: 'name',
            	queryMode: 'local',
            	value: 'ACTIVE',
            	forceSelection: false
            }, {
              itemId: 'studentId',
            	xtype: 'customcombobox',
    			name: 'studentId',
    			fieldLabel: getCommonTranslation('STUDENT_CODE_NAME'),
    			store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'studentNameOrCode',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			forceSelection:true,
    			queryCaching: false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode} / {studentName}' +
    					'</div>';
    				}
    			}
            }, {
              itemId: 'applicantId',
            	xtype: 'customcombobox',
    			name: 'applicantId',
    			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
    			store: 'feeandpayment.managebill.Applicant',
				valueField: 'id',
				displayField: 'printName',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				forceSelection:true,
				hidden:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode} / {studentName}' +
    					'</div>';
    				}
    			}
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
                itemId: 'scholarshipId',
                name: 'scholarshipId',
                enableKeyEvents: true,
                vtype: 'NospaceAsInput',
                store:'scholarships.ScholarshipIdNameStore',
    			width:226,
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'qry',
    			minChars:3,
    			typeAhead:false,	
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
            }, {
                xtype: 'customcombobox',
                fieldLabel:  getCommonTranslation('REQUEST_BY'),
                name: 'requestById',
                itemId: 'requestById',
                editable: false,
                store: 'scholarships.RequestByStore',
                valueField: 'id',
                displayField: 'value'
            }, {
                xtype: 'customcombobox',
                fieldLabel:  getCommonTranslation('REQUEST_ASSIGNED_TO'),
                name: 'requstAssigntoId',
                itemId: 'requstAssigntoId',
                store: 'scholarships.RequestAssignedToStore',
                displayField: 'value',
                minChars:3,
    			typeAhead:false,
    			valueField: 'id',
    			queryParam:'qry',
    			//hideTrigger:true,
    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			forceSelection:true,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}'  +
    					'</div>';
    				}
    			}
            },{
                xtype: 'customcombobox',
                fieldLabel:  getCommonTranslation('SERVICE_REQUEST_STATUS'),
                name: 'requestStatus',
                itemId: 'requestStatus',
                editable: false,
                store: 'scholarships.ServiceRequestStatusStore',
                valueField: 'value',
                displayField: 'name',
                queryMode: 'local',
                selectOnFocus: true,
                forceSelection: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'fromDate',
				itemId : 'fromDate',
				endDateField : 'toDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange',
				maxValue: new Date()
            }, {
            	xtype : 'datefield',
				anchor : '100%',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'toDate',
				itemId : 'toDate',
				maxValue:new Date(),
				startDateField : 'fromDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.DATE_FORMAT,
				vtype : 'daterange'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',

            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'ScholarshipListSearchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation('CLEAR_SEARCH'),
                itemId: 'ClearSearchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});