/**
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.securitygatemanagement.SgVisitorFilter',{
	extend: 'Ext.form.Panel',
	alias: 'widget.sgvisitorfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'visitorNo',
			itemId:'visitorNo',
			queryParam:'visitorNo',
			store:'sgvisitor.SgAllVisitorNoStore',
			fieldLabel: getServiceRequestTranslation('VISITOR_NO'),
			valueField: 'value',
			displayField: 'value',
			queryParam:'visitorNo',
			minChars:3,
			typeAhead:false,
			//hideTrigger:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
      	    forceSelection : true,triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			forceSelection:true,
			maxLength: 45,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'visitorCategory',
			itemId: 'visitorCategory',
			fieldLabel: getServiceRequestTranslation('SG_VISITOR_CATEGORY'),
			store:'sgappointment.sgappointment.SGVisitorCategoryStore',
			valueField: 'id',
			displayField: 'value',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: 'all',
			hideTrigger:false,
			editable: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'visitorName',
			itemId:'visitorName',
			fieldLabel: getServiceRequestTranslation('VISITOR_NAME'),
			store: 'sgvisitor.SgAllVisitorNameStore',
			valueField: 'value',
			displayField: 'value',
			queryParam:'visitorName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			maxLength: 45,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'visitorCardNo',
			itemId: 'visitorCardNo',
			fieldLabel: getServiceRequestTranslation('CARD_NO'),
			store: 'sgvisitor.SgVisitorCardStore',
			valueField: 'value',
			displayField: 'value',
			queryParam:'cardNo',
			enableKeyEvents  : 'true',
			minChars:3,
			forceSelection:true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: 'all',
			hideTrigger:false,
			editable: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'studentName',
			itemId:'studentName',
			fieldLabel: getServiceRequestTranslation('STUDENT_NAME'),
			store: 'sgvisitor.SgVisitorFindByStudent',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentName',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			maxLength: 45,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getServiceRequestTranslation('MORE_FILTERS'),
		titleCollapse: true,
		defaults : {
			labelAlign:'top',
//			tdAttrs: { style: 'padding: 5px;' }
		},
		style: {
			marginTop: '33px!important'
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'personToMeet',
				itemId:'personToMeet',
				fieldLabel: getServiceRequestTranslation('PERSON_TO_MEET'),
				store: 'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
				valueField: 'value',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				maxLength: 45,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
				xtype : 'customcombobox',
				fieldLabel : getServiceRequestTranslation('BOOKING_ID'),
				name : 'bookingID',
				itemId : 'bookingID',
				store : 'sgappointment.sgappointment.SGBookingIDStore',
				valueField : 'value',
				displayField : 'value',
				queryParam : 'codeOrName',
				minChars : 3,
				typeAhead : false,
				hideTrigger : false,
				forceSelection : true,
				// allowBlank:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				triggerAction: '',
				emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
				maxLength: 45,
				listConfig : {
					listeners : {
						beforeshow : function(
								picker) {
							picker.minWidth = picker
							.up('combobox')
							.getSize().width;
						}
					},
					loadingText : getCommonTranslation('SEARCHING'),
					emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl : function() {
						return '<div class="search-item">'
						+ '{value}'
						+ '</div>';
					}
				}
			}]
		}, {
			xtype : 'fieldcontainer',
			width: '100%',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getServiceRequestTranslation('MEETING_TIME')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{ 
				xtype : 'fieldcontainer',
				width: '100%',
				layout:'hbox',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'timefield',
					name : 'fromTime',		
					itemId : 'fromTime',			
					fieldLabel:getServiceRequestTranslation('IN_TIME'),
					format:'g:i A',
					//vtype: 'timerange',
					//endTimeField : 'toTime',
					width:107,
					editable: false,
					listeners:{
						change:function(obj,val){
							if (!isNullOrEmpty(val)) {
								var sDate = Ext.Date.add(val, Ext.Date.MINUTE, 15);
								obj.nextSibling().setMinValue(sDate);	
							}
						}
					},
					
				},{
					xtype : 'timefield',
					name : 'toTime',		
					itemId : 'toTime',			
					fieldLabel:getServiceRequestTranslation('OUT_TIME'),
					format:'g:i A',
					//vtype: 'timerange',
					//startTimeField :'fromTime',
					width:107,
					editable: false,
					listeners:{
						change:function(obj,val){
							if (!isNullOrEmpty(val)) {
								var eDate = Ext.Date.add(val, Ext.Date.MINUTE, -15);
								obj.previousSibling().setMaxValue(eDate);
							}
						}
					},
				}]
			}
			]},{
				xtype : 'fieldcontainer',
				width: '100%',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype:'displayfield',
					value:'<b class="menu-title">'+getServiceRequestTranslation('MEETING_DATE')+'</b>',
					style: {
						textDecoration: "underline"
					}
				},{ 
					xtype : 'fieldcontainer',
					width: '100%',
					layout:'hbox',
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{
						xtype: 'datefield',
						name: 'startDate',
						itemId: 'startDate',
						vtype: 'daterange',
						endDateField: 'endDate',
						fieldLabel: getAdmissionTranslation('FROM_DATE'),
						//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
					},{
						xtype: 'datefield',
						name: 'endDate',
						itemId: 'endDate',
						vtype: 'daterange',
						startDateField: 'startDate',
						fieldLabel: getAdmissionTranslation('TO_DATE'),
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
						//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					},{
						xtype: 'checkboxfield',
						width: 'auto',
						itemId:'currentlyInPremises',
						style: {
							marginTop: '25px',
							marginLeft: '10px'
						},
						boxLabel: getServiceRequestTranslation('VISITOR_CURRENTLY_IN_PREMISES'),
						name: 'currentlyInPremises',
						inputValue : true,
						uncheckedValue: false 
					}]
				}
				]},]}, {
					xtype : 'fieldcontainer',
					width : 'auto',
					cls : 'windowBtnPos',
					items : [ {
						xtype : 'button',
						text : getCommonTranslation('SEARCH'),
						itemId : 'searchButtonId',
						buttonAlign : 'left',
						ui : 'CustomBtnSubmit',
						scale: CONSTANTS.BUTTONSIZE,
						formBind : true,
						style:{marginLeft:'-1px !important'},
					}, {
						xtype: 'button',
						text : getCommonTranslation('RESET'),
						itemId : 'resetButtonId',
						buttonAlign : 'left',
						ui : 'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE
					} ]
				}]
});
