Ext.define('Academia.view.securitysetup.RolePrivilegeGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.roleprivilege',	
	store:'securitysetup.AccessPrivilege',
	titleCollapse: true,
	columns:[{
		header: 'Feature Privilge ID',
		hidden:true,
		dataIndex:'featurePrivilegeId'
	},{
		header:'Portal',
		dataIndex:'portal',
		flex:.1,
		renderer:function(value) {
			return value.value;
		}			
	},{
		header:'Module',
		dataIndex:'module',
		flex:0.2,
		renderer:function(value) {
			return value.value;
		}	
	},{
		header:'Submodule',
		dataIndex:'subModule',
		flex:0.2,
		renderer:function(value) {
			return value.value;
		}	
	},{
		header:'Feature',
		dataIndex:'featureName',
		flex:.2,
		sortable: true
	},{
		header:'Privilege',
		dataIndex:'privilege',
		flex:0.1,
		renderer:function(value) {
			return value.value;
		}	
	},{
		xtype:'checkcolumn',
		header:'Granted',
		flex:.1,
		dataIndex : 'granted'			
	},{
		xtype:'checkcolumn',
		flex:.1,
		header:'Override',
		dataIndex : 'whetherOverrideAllowed'		
	}],
	tbar:[{
		xtype:'customcombobox',
		store:'securitysetup.PortalStore',
		displayField:'portalName',
		valueField:'portalName',
		editable:false,
		itemId:'comboPortal',
		queryMode:'local',
		emptyText:'Select Portal'
	},{
		xtype:'customcombobox',
//		store:'securitysetup.ModuleStore',
		displayField:'moduleName',
		listeners: {
			render: function(combo) {
				var store = Ext.create('Academia.store.securitysetup.ModuleStore');
				combo.bindStore(store);
			}
		},
		valueField:'id',
		editable:false,
		disabled:true,
		queryMode: 'local',
		itemId:'comboModule',
		emptyText:'Select Module'	
	},{
		xtype:'customcombobox',
//		store:'securitysetup.SubModuleStore',
		displayField:'moduleName',
		queryMode: 'local',
		listeners: {
			render: function(combo) {
				var store = Ext.create('Academia.store.securitysetup.SubModuleStore');
				combo.bindStore(store);
			}
		},
		valueField:'moduleName',
		editable:false,
		disabled:true,
		itemId:'comboSubModule',
		emptyText:'Select Sub Module'
	},{
		xtype:'button',
		text:getCommonTranslation('SEARCH'),
		itemId:'btnSearchRolePrivilege'
	},{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'btnSavePrivilege'
	},{
		xtype:'button',
		text:getCommonTranslation('RESET'),
		itemId:'btnResetPrivilege'
	},{
		xtype:'button',
		text:getCommonTranslation('GRANT_ALL'),
		itemId:'btnGrantAllPrivilege'
	},{
		xtype:'button',
		text:getCommonTranslation('REVOKE_ALL'),
		itemId:'btnRevokeAllPrivilege',
		disabled:true
	}]	
});