/**
 * @author pritam.patil
 * This is used for faculty List
 */
Ext.define('Academia.view.servicerequest.FacultyRequestComboPanel',{
	extend:'Ext.form.Panel',
	alias:'widget.facultyrequestcombopanel',
	autoScroll: false,
	frame: false,
	plugins : "formlabelrequired",
	items:[{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
		xtype:'customcombobox',
		fieldLabel: getServiceRequestTranslation('REQUEST_CATEGORY'),
		store:'servicerequest.ServiceRequestConfiguredCategoryStore',
		itemId:'serviceRequestCategoryCombo',
		displayField:'displayValue',
		valueField:'value',
		editable:false,
		emptyText :getServiceRequestTranslation('REQUEST_CATEGORY_SELECT'),
		allowBlank: false
	},{
		xtype:'customcombobox',
		fieldLabel: getServiceRequestTranslation('REQUEST_TYPE'),
		store:'servicerequest.ServiceRequests',
		itemId:'serviceRequestCombo',
		displayField:'value',
		valueField:'id',
		queryMode: 'local',
//		hidden:true,
		emptyText :getServiceRequestTranslation('REQUEST_TYPE_EMPTY_TEXT'),
		disabled : true,
		editable:false,
		allowBlank: false
	}]
    },{
    	xtype : 'fieldcontainer',
		width : '100%',
		items : [ {
			xtype : 'button',
			text : getServiceRequestTranslation('RAISE'),
			itemId : 'raiseButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype: 'button',
			text: getServiceRequestTranslation('CANCEL'),
			itemId: 'cancelButtonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}]
    }]
});
