/**
 * @author pritam.patil
 *  certificate Request Details Panel 
 */
Ext.define('Academia.view.servicerequest.HostelServiceRequest.HostelLeaveRequestDetailsPanel', {
	 extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.hostelleaverequestdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        itemId: 'requestorId',
        name: 'requester',
        hidden: true
    }, {
        xtype: 'hidden',
        name: 'leaveRequest',
        itemId: 'leaveRequest',
        value: 'Other'
    },{
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true
    }, {
    xtype: 'hidden',
    itemId: 'hostelRoomAllotmentId',
    name: 'hostelRoomAllotmentId',
 
    }, {
        xtype: 'hidden',
        name: 'defultAssgineID',
        itemId: 'defultAssgineID',
       
    }, {
        xtype: 'hidden',
        name: 'defultAssgineName',
        itemId: 'defultAssgineName',
       
    }, {
        xtype: 'hidden',
        name: 'defultAssgineCode',
        itemId: 'defultAssgineCode',
       
    }, {        
            xtype: 'fieldcontainer',
            defaults: {
                labelAlign: 'top'                
            },
            items: [{
                xtype: 'requesterdetailspanel',
                itemId: 'requesterDetails',
                margin: 0
            }]        
    }, {
        xtype: 'basicdetails',
        style: {
            marginBottom: '-29px',
            marginLeft: '0px'
        }
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        style: {
            marginLeft: '10px'
            //marginBottom: '45px'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('LEAVE_REQUEST_FROM_DATE'),
            name: 'fromDate',
            valueField: 'value',
            itemId: 'startDate',
            displayField: 'name',
            allowBlank: false,
            editable: false,
            listeners: {
            	render: function(field) {
            		field = dateFormatRender(field);						
    				field.setValue(new Date());
            		//return dateFormatRender(field);
            	}
            },
            minValue: new Date()
        },{
			xtype : 'timefield',
			name : 'fromTime',	
			itemId : 'startTimeItemId',
			fieldLabel:getCommonTranslation('FROM_TIME'),
			format:CONSTANTS.DISPLAY_TIME_FORMAT,
			allowBlank:false,
			editable: false,
		   	width: 120,
			submitFormat : 'g:i A',
			vtype: 'timerange',
			//endTimeField : 'enddateItemId',
			listeners: {
				render: function(field) {
					return timeFormatRender(field);
				}
			}
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        style: {
            marginLeft: '10px',
            marginBottom: '45px'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('LEAVE_REQUEST_TO_DATE'),            
            name: 'toDate',
            valueField: 'id',
            itemId: 'enddateItemId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local',
            listeners: {
            	render: function(field) {
            		field = dateFormatRender(field);						
    				field.setValue(new Date());
            		//return dateFormatRender(field);
            	}
            },
            minValue: new Date()
        }, {
			xtype : 'timefield',
			name : 'toTime',
			itemId : 'toTimeItemId',
			fieldLabel:getCommonTranslation('TO_TIME'),
            editable: false,
            format:CONSTANTS.DISPLAY_TIME_FORMAT,
			submitFormat : 'g:i A',
			width: 120,
		//	startTimeField :'punchStartTimeItemId',
			listeners: {
				render: function(field) {
					return timeFormatRender(field);
				}
			}
		}]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        style: {
            marginLeft: '10px',
            marginTop: '-37px'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("LEAVE_TYPE"),
			name: 'leaveType',
			itemId:'leaveType',
			store: 'common.StudentLeaveTypeStore',
			displayField: 'value',
			allowBlank: false,
			valueField: 'id',
		}]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '10px'
        },
        items: [{
            xtype: 'button',
            itemId: 'btnSaveRequestDetails',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});