/**
 * @author Shashank Jain
 */
Ext.define('Academia.view.servicerequest.ReAssignRequestServiceRequestWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.reassignrequestservicerequestwin',
    title: getCommonTranslation('CHANGE_ASSIGNEE'),
    autoScroll: true,
    maxHeight: 600,
    modal: true,
    items: [{
        xtype: 'form',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        plugins: "formlabelrequired",
        items: [{
       	 xtype: 'customcombobox',
         fieldLabel: getCommonTranslation('ASSIGNED_TO'),
         name: 'FACULTY_CODE',
         itemId:'facultyCodeItemId',
         store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyComboForReAssignRequest'),
         valueField: 'id',
			 displayField: 'valueCode',
			 queryParam:'nameOrCode',
			 minChars:3,
			 typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		triggerAction: '',
		 forceSelection:true,
		 allowBlank:false,
		 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		 listConfig: {
			 listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
    },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls : 'windowBtnPos',
    		style :{marginLeft: '-1px',marginTop:'10px'},
    		
            items: [{
            	xtype: 'button',
                itemId: 'formSubmitButtonId',
                action: 'Submit',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                disabled: true
            },{
            	xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'Cancel',
                itemId: 'winCancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});