/**
 * @author pritam.patil
 *  certificate Request Details Panel 
 */
Ext.define('Academia.view.servicerequest.certificateissuerequest.CertificateRequestDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.certificaterequestdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        itemId: 'requestorId',
        name: 'requester',
        hidden: true
    }, {
        xtype: 'hidden',
        name: 'certificateStatus',
        value: 'CERTIFICATE_REQUESTED'
    }, {        
            xtype: 'fieldcontainer',
            defaults: {
                labelAlign: 'top'                
            },
            items: [{
                xtype: 'requesterdetailspanel',
                itemId: 'requesterDetails',
                margin: 0
            }]        
    }, {
        xtype: 'basicdetails',
        style: {
            marginBottom: '-29px',
            marginLeft: '0px'
        }
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        style: {
            marginLeft: '10px'
            //marginBottom: '45px'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CERTIFICATE_CATEGORY'),
            name: 'certificateCategory',
            store: 'servicerequest.servicerequestsettings.CertificateCategories',
            valueField: 'value',
            itemId: 'certificateCategoryItemId',
            displayField: 'name',
            allowBlank: false,
            editable: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CERTIFICATE_TYPES'),            
            name: 'certificateId',
            store: 'servicerequest.certificateissuerequest.CertificatesTypes',
            valueField: 'id',
            itemId: 'certificateRequestCertificateTypesId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        style: {
            marginLeft: '10px',
            marginBottom: '45px'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('COURSE_CERTIFICATE'),
            name: 'courseId',
            store: 'servicerequest.servicerequestsettings.CourseCertificates',
            valueField: 'id',
            itemId: 'courseCertificateItemId',
            displayField: 'value',
            allowBlank: false,
            queryMode: 'local',  
            editable: false,
            hidden:true,
            disabled:true
        }, {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('COMMUNITY_CERTIFICATE'),            
            name: 'communityId',
            store: 'servicerequest.servicerequestsettings.CommunityCertificates',
            valueField: 'id',
            itemId: 'communityCertificateId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local',  
            hidden:true,
            disabled:true
        }]
    },{
        xtype: 'fieldset',
        title: getServiceRequestTranslation('DOCUMENTS'),
        collapsed: false,
        layout: {
            type: 'vbox'
        },
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'radiogroup',
                itemId: 'isOriginalRadio',
                allowBlank: false,
                items: [{
                    boxLabel: getServiceRequestTranslation('ORIGINAL'),
                    name: 'isOriginal',
                    inputValue: true,
                    checked: true
                }, {
                    boxLabel: getServiceRequestTranslation('DUPLICATE'),
                    name: 'isOriginal',
                    inputValue:false
                }]
            }, {
                xtype: 'numberfield',
                fieldLabel: getServiceRequestTranslation('NO_OF_COPIES'),
                itemId: 'noOfCopies',
                allowBlank: false,
                name: 'copies',
                minValue: 0,
                value: 0,
                hidden: true,
                disabled:true
            }]
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '10px'
        },
        items: [{
            xtype: 'button',
            itemId: 'btnSaveRequestDetails',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});