/**
 * @author pritam.patil
 * This is used to show pop up of escalate details on click of escalate button 
 */
Ext.define('Academia.view.servicerequest.common.EscalateDetailsPopUp', {
    extend: 'Ext.window.Window',
    alias: 'widget.escalatedetailspopupwindow',
    modal: true,
    resizable: false,
    autoScroll: true,
    frame: true,
    title: getServiceRequestTranslation('ESCALATE_DETAILS'),
    plugins: "formlabelrequired",
    items: [{
        xtype: 'form',
        itemId: 'escalateDetailsForm',
        items: [{
            xtype: 'hidden',
            itemId: 'ed_version_field',
            name: 'serviceRequestId'
        }, {
            xtype: 'fieldcontainer',
            layout: 'vbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'displayfield',
                itemId: 'userId',
                fieldLabel: getServiceRequestTranslation('USER_ID'),
                name: 'userId'
            }, {
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('ESCALATION_DATE'),
                name: 'actionDate',
                itemId: 'startDate',
                allowBlank: false,
              //--submitFormat: CONSTANTS.DATE_FORMAT,
//                value:new Date(),
                readOnly:true,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
            }, {
                xtype: 'textareafield',
                name: 'remarks',
                maxLength : 255,
                enforceMaxLength : true,
                fieldLabel: getServiceRequestTranslation('ESCALATION_REMARKS')
            }, {
                xtype: 'livesearchcombo',
                fieldLabel: getServiceRequestTranslation('SELECT_APPROVER'),
                
                name : 'escalatedApprover',
                allowBlank : false
              
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getServiceRequestTranslation('SUBMIT'),
                itemId: 'approvalDetailsSubmitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'approvalDetailsCancelButtonId',
                scale: CONSTANTS.BUTTONSIZE

            }]
        }]
    }]

});